#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc THM::header { objspec flags } {
        global TheoremWidgets_flags
        switch [lindex $objspec 0] "CODE" {
            return ""
        } default {
            set thmname [lindex $objspec 0]
            set thmtype [lindex $objspec 1]
            set theory [lindex $objspec 2]
            return [list \
                [list "$thmname " $TheoremWidgets_flags(thmNameLook)] \
                [list " ($thmtype in $theory.th)\n" $TheoremWidgets_flags(thmKindLook)]]
        }
}


proc THM::code { objspec } {
        switch [lindex $objspec 0] "CODE" {
            return [lindex $objspec 1]
        } default {
            set thmname [lindex $objspec 0]
            set thmtype [lindex $objspec 1]
            set theory [lindex $objspec 2]
            return "[lindex $objspec 1] [ml_string [lindex $objspec 2]] [ml_string [lindex $objspec 0]]"
        }
}

proc THM::generate { objspec flagsvar } {
        upvar 1 $flagsvar flags
        global TheoremWidgets_flags
        if {$flags(richtext) || $flags(structuredtext)} {
            HolPP::generate [THM::code $objspec] HolPP.pp_thm THM flags
        } else {
            if ![info exists flags(showTypes)] { set flags(showTypes) $TheoremWidgets_flags(showTypes) }
            if ![info exists flags(showAssums)] { set flags(showAssums) $TheoremWidgets_flags(showAssums) }
            list [list [ML "Plaintext.thm_to_string \{
                        output_width=$flags(width),
                        show_types=[ml_bool $flags(showTypes)],
                        show_assums=[ml_bool $flags(showAssums)]
                \} ([THM::code $objspec])"]]
        }
}

proc THM::select_subobject { textw objspec path } {
        return [HolPP::select_subobject THM $textw $objspec $path]
}
