structure pp_lib  = 
struct

val pp_lib = 
   Library.new_library
         {name = "pp",
          doc = "Infrastructure common across all HOL ML-Pretty Pretty Printers (hol.pp, zhol.pp etc.), by Richard Boulton and Donald Syme",
          path = pp_lib_path,
          parents = [find_library "mlpretty_runtime", find_library "interface_maps"],
          theories = [],
          code = [
		"pp_labels.sig",
		"pp_labels.sml",
		"pp_stringtables.sig",
		"pp_stringtables.sml",
		"pp.sig"
	  ],
          help = [(pp_lib_path ^ "help/entries/"), (pp_lib_path ^ "help/internals/")],
          loaded = "fn () => ()"};
end;

