(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)



signature GTrees_sig =
  sig

    structure BwdProofs : BwdProofs_sig
    structure PartialBwdProofs : PartialBwdProofs_sig
    type focus (* = int list *)

    datatype proposition = PROVED of thm | POSED of goal
    val is_proved : proposition -> bool
    val is_posed : proposition -> bool
    val dest_proved : proposition -> thm
    val dest_posed : proposition -> goal


    (* Starting a proof *)
    type pstate (* = (BwdProofs.bwdop * gtree list) *)
                                      
    val empty_goal : pstate
    val set_goals : (goal list * BwdProofs.bwdop) -> pstate

    (* Applying a tactic to a goal *)
    val expand : bool -> (tactic * BwdProofs.tac) -> focus -> pstate -> pstate
    val close : focus -> pstate -> pstate
    val THENL_mismatch : pstate -> bool
    val adjust_THENLs : pstate -> BwdProofs.bwdop

    (* Determining where the focus should be *)
    val first_focus : pstate -> focus
    val active_foci : pstate -> focus list
    val next_focus : pstate -> focus -> focus
    
    (* Seeing what the state of the proof manager is, at a focus *)
    val focus_is_opened : pstate -> focus -> bool
    val focus_is_active : pstate -> focus -> bool
    val current_tac : pstate -> focus -> BwdProofs.tac

    val propositions_at_focus : pstate -> focus -> proposition list
    val at_THENL_start : pstate -> focus -> bool
    val propositions_at_THENL_start : pstate -> focus -> proposition list
    val focused_case_at_THENL_start : pstate -> focus -> int
    val refocus_at_THENL_start : int -> pstate -> focus -> focus

    val split_at_focus : focus -> pstate -> BwdProofs.bwdop
    val delete_at_focus : focus -> pstate -> BwdProofs.bwdop
    val insert_space_before_focus : focus -> pstate -> BwdProofs.bwdop
    val trim : pstate -> BwdProofs.bwdop
    val cleanup : pstate -> BwdProofs.bwdop

    (* use modify_proof with trim, insert_space_before_focus etc., i.e.
       for any operations that effect the proof but not the goaltree *)
    val modify_proof : (pstate -> BwdProofs.bwdop) -> pstate -> pstate
    (* Seeing what the state of the proof manager is, at the top *)
    val top_is_proved : pstate -> bool
    val final_thm : pstate -> thm
    val initial_goal : pstate -> goal

    val entire_partial_proof : pstate -> PartialBwdProofs.pbwdop
    val executed_proof : pstate -> BwdProofs.bwdop
    val entire_proof : pstate -> BwdProofs.bwdop
end;

