(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)





structure BwdProofs : BwdProofs_sig = struct
    type tac = string
    datatype bwdproof = BWDPROOF of bwdop list
    and bwdop = BWDTHENL of bwdproof list | 
                BWDTAC of tac
    (* proof layout *)
(*    fun layout_thenl (f::b) = 
       let fun spacer s = "   " ^ s
           fun commaizer s = " , " ^ s
           fun commaize_first (f::b) =
             (commaizer f)::(map spacer b)
       in (map spacer f)@flatten (map commaize_first b)
       end
    
    fun split_aux ("\n"::s) l = implode (rev l)::split_aux s []
      | split_aux (c::t) l = split_aux t (c::l)
      | split_aux [] l = [implode (rev l)]
    fun split s = split_aux (explode s) []
    
    fun join sl = end_itlist (fn s => fn r => s ^ "\n" ^ r) sl
    
    fun layout_proof_aux (BWDTHEN proofs) =

(s,pl)) =
        if (length (mk_set pl) = 1)
        then let val pl' = layout_proof_aux (hd pl)
             in (s ^ " THEN")::pl'
             end
        else 
        if (length pl = 0)
        then (split s)
        else let val pl' = layout_thenl (map layout_proof_aux pl)
             in [s ^ " THENL ["]@pl'@["]"]
             end
    val layout_proof = join o layout_proof_aux *)
end

structure PartialBwdProofs : PartialBwdProofs_sig = struct
    structure BwdProofs = BwdProofs
    datatype pbwdproof = PBWDPROOF of (int * pbwdop list)
    and pbwdop = PBWDTHENL of pbwdproof list | 
                 PBWDTAC of BwdProofs.tac
    open BwdProofs
    exception PROOF_IS_PARTIAL
    fun chop n alist = fst (Lib.split_after n alist) handle _ => alist

    fun pbwdproof_to_bwdproof (PBWDPROOF (focus,l)) =
           BWDPROOF (map pbwdop_to_bwdop l)
    and pbwdop_to_bwdop (PBWDTHENL l) = 
           BWDTHENL (map pbwdproof_to_bwdproof l)
      | pbwdop_to_bwdop (PBWDTAC t) =
           BWDTAC t

    fun harden_pbwdproof (PBWDPROOF (focus,l)) =
           PBWDPROOF (focus,map harden_pbwdop (chop focus l))
    and harden_pbwdop (PBWDTHENL l) = 
           PBWDTHENL (map harden_pbwdproof l)
      | harden_pbwdop (PBWDTAC t) =
           PBWDTAC t

    fun bwdop_to_hard_pbwdop (BWDTAC x) = 
           PBWDTAC x
      | bwdop_to_hard_pbwdop (BWDTHENL cases) = 
           PBWDTHENL (map bwdproof_to_hard_pbwdproof cases)
    and bwdproof_to_hard_pbwdproof (BWDPROOF seq) =
           PBWDPROOF ((length seq) + 1, map bwdop_to_hard_pbwdop seq)

    fun bwdop_to_soft_pbwdop (BWDTAC x) = 
           PBWDTAC x
      | bwdop_to_soft_pbwdop (BWDTHENL cases) = 
           PBWDTHENL (map bwdproof_to_soft_pbwdproof cases)
    and bwdproof_to_soft_pbwdproof (BWDPROOF seq) =
           PBWDPROOF (1, map bwdop_to_soft_pbwdop seq)

end



