(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




signature RecTypeDB_sig = sig

    type db;
    val empty : db;
    val add : db * {typename: string, axiom_code:string, axiom:thm} -> db;
    val all : db -> {typename: string, axiom_code:string, axiom:thm} list;
    val axiom_for_typename : db * string -> thm option;
    val axiom_code_for_typename : db * string -> string option;
    val typenames : db -> string list;

    val current : db ref;

end;

structure RecTypeDB : RecTypeDB_sig = struct
    type db = {typename: string, axiom_code:string, axiom:thm} list
    val empty = []:db;
    fun add (x,y) = y::x;
    val all = I;
    fun axiom_for_typename (db:db,typename) = 
        SOME (#axiom (first (fn {typename=typename',...} => typename' = typename) db))
        handle _ => NONE
    fun axiom_code_for_typename (db:db,typename) = 
        SOME (#axiom_code (first (fn {typename=typename',...} => typename' = typename) db))
        handle _ => NONE

    fun typenames (db:db) = map #typename db;

    val current = ref 
        [{typename="num",axiom_code="theorem \"prim_rec\" \"num_Axiom\"", axiom=theorem "prim_rec" "num_Axiom"},
         {typename="list",axiom_code="theorem \"list\" \"list_Axiom\"", axiom=theorem "list" "list_Axiom"},
         {typename="sum",axiom_code="theorem \"sum\" \"sum_Axiom\"", axiom=theorem "sum" "sum_Axiom"}]

end;

    
signature CasesDB_sig = sig

    type db;
    val empty : db;
    val add : {cases_thm_code:string, cases_thm:thm} * db -> db;
    val all : db -> {cases_thm_code:string, cases_thm:thm} list;

    val current : db ref;

end;

structure CasesDB : CasesDB_sig = struct
    type db = {cases_thm_code:string, cases_thm:thm} list
    val empty = []:db;
    val add = op ::;
    val all = I;
    val current = ref empty;
end;



