(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




(*--------------------------------------------------------------      
 * current_theory_notify.nw,v 1.1.1.1 1995/09/06 01:39:43 drs1004 Exp         
 * use "packages/tkhol_slave/src/current_theory_notify.sml";
 *---------------------------------------------------------------*)
                                                                        

structure CurrentTheoryNotification : CurrentTheoryNotification_sig =
struct
        open Rsyntax;
        type client = 
                string * 
                (string -> unit) *      (* called when theory graph changes *)
                (bool -> unit);         (* called when current theory mode change *)

        fun mk_client x = (x:client);

        val notification_list = ref []: (client list) ref;
        fun clients () = (!notification_list);

        fun add_client client =
                (notification_list := 
                        (append [client] (! notification_list));
                ());

        fun remove_client clientname =
                (notification_list := 
                    filter ( fn (cl,_,_) => not(cl = clientname)) (! notification_list);
                ());
        
        

        fun most_general_wrapper operation arg = 
            let val old_parents = parents "-"
                val old_current = current_theory()
                val old_mode = draft_mode()
                val res = operation arg
            in (
              if (not (old_current = current_theory())) 
              then (map ( fn (_,client,_) => client (current_theory())) (!notification_list); ())
              else if (not (old_parents = parents "-")) 
              then (map ( fn (_,client,_) => client (current_theory())) (!notification_list); ())
              else ()
            ; if (not (old_mode = draft_mode())) 
              then (map ( fn (_,_,client) => client (draft_mode())) (!notification_list); ())
              else ()
            ; res
            )
            end
        val load_theory = most_general_wrapper Theory.load_theory
        val new_theory = most_general_wrapper Theory.new_theory
        val extend_theory = most_general_wrapper Theory.extend_theory
        val close_theory = most_general_wrapper Theory.close_theory
        val new_parent = most_general_wrapper Theory.new_parent
        val load_library = most_general_wrapper Library.load_library
        fun prim_load_library x = most_general_wrapper (Library.prim_load_library x)

        fun test () = 
            let exception THEORY_GRAPH_CHANGE
                exception CURRENT_THEORY_MODE_CHANGE in (
                add_client(mk_client(
                        "client1", 
                        (fn x => raise THEORY_GRAPH_CHANGE),
                        (fn x => raise CURRENT_THEORY_MODE_CHANGE)));
                ((new_theory "test"; false) handle THEORY_GRAPH_CHANGE => true)
                andalso ((close_theory(); false) handle CURRENT_THEORY_MODE_CHANGE => true)
           ) end;

end;


open CurrentTheoryNotification;


