(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




(*============================================================================
 * use "/homes/drs1004/projects/hol90_Z/src/Zpreterms.sig";; 
 * use "/homes/drs1004/projects/hol90_Z/src/Zpreterms.sml";; 
 * use "/homes/drs1004/projects/hol90_Z/src/preterm_ops.sig";; 
 * use "/homes/drs1004/projects/hol90_Z/src/preterm_ops.sml";; 
 *
 * EXAMPLES

 * Load in the code up to preterms:

  new_theory "myZ";.
  Globals.library_path := (!Globals.library_path)@["/homes/drs1004/projects/hol90_Z/"];
  prim_load_library Lib.interpret {lib = find_library"Z",theory="-"};
  load_library {lib = find_library"BirthdayBook",theory="-"};
  Z.register_defined_schema{name="BirthdayBook",theory="BirthdayBook"};
  Z.register_defined_schema{name="BirthdayBook2",theory="BirthdayBook"};
  Z.register_defined_schema{name="BirthdayBook5",theory="BirthdayBook"};
  Z.register_defined_schema{name="AddBirthday5",theory="BirthdayBook"};
  Z.register_defined_schema{name="FindBirthday5",theory="BirthdayBook"};
  use "../hol90_Z/src/Z.sig";  use "../hol90_Z/src/Z.sml";  
 
 * (--`BirthdayBook`--);
 * (--`BirthdayBook'`--);
 * (--`BirthdayBook''`--);
 * (--`AddBirthday`--);
 * (--`AddBirthday /\ FindBirthday`--);
 * (--`AddBirthday \/ FindBirthday`--);
 * (--`!BirthdayBook. T`--);;
 * (--`AddBirthday''`--);
 * (--`SCHEMA [x IN NN; y IN NN_1] [x > y]`--);
 * (--`SCHEMA [AddBirthday; x IN NN; y IN NN_1] [x > y]`--);
 * (--`SCHEMA [BirthdayBook'; x IN NN; y IN NN_1] [x > y]`--);
 * (--`SCHEMA [AddBirthday; x IN {y | y > x}; y IN NN_1] [x > y]`--);
 * (--`SCHEMA [Add; x IN NN; y IN NN_1] [x > y]`--);
 * (--`SCHEMA [x IN NN] [x > y]`--);
 * (--`DELTA BirthdayBook`--);
 * (--`XI BirthdayBook`--);
 * (--`SCHEMA [DELTA BirthdayBook; x IN NN] [x > x]`--);
 * (--`SCHEMA [DELTA BirthdayBook; x IN NN] [x > x; x IN known ]`--);
 * (--`SCHEMA [DELTA BirthdayBook; x IN NN] [x > x; x IN known'' ]`--);
 * (--`SCHEMA [XI BirthdayBook; x IN NN] [x > x]`--);
 * (--`d = SCHEMA [DELTA BirthdayBook] [known = known']`--);
 * (--`d = SCHEMA [SCHEMA [x IN NN] [x > 100]] [x = 101]`--);

val KnownEqDomBirthday = 
save_thm("KnownEqDomBirthday", prove((--`!BirthdayBook. known = dom birthday`--),
        REWRITE_TAC [definition "Z" "BOTH",definition "Z" "CONJL",definition "Z" "SCHEMA",definition "BirthdayBook" "BirthdayBook",definition "list" "MAP"]
        THEN PBETA_TAC
        THEN REWRITE_TAC [UNCURRY_DEF]
        THEN REPEAT PSTRIP_TAC
));

 *============================================================================*)


signature ZPretermOps_sig = sig
        type preterm
        type preterm_in_env
        type schema_context
        type varstruct
        val dest_SchemaConstant : preterm -> string
        val is_SchemaConstant : preterm -> bool
        val mk_SchemaConstant : string -> preterm_in_env

        val mk_SCHEMA' : 
                {schemas:(preterm_in_env * varstruct) list,
                 decs:(string * preterm_in_env) list,
                 body:preterm_in_env list} -> preterm_in_env
        val dest_SCHEMA' : preterm -> 
                {schemas:(preterm * varstruct) list,
                 decs:(string * preterm) list,
                 body:preterm list}
        val is_SCHEMA' : preterm -> bool

        val mk_Delta : string -> preterm_in_env
        val dest_Delta : preterm -> string
        val is_Delta : preterm -> bool

        val mk_Xi : string -> preterm_in_env
        val dest_Xi : preterm -> string
        val is_Xi : preterm -> bool

        val expand_Z': schema_context option -> preterm -> preterm_in_env
        val expand_Z: preterm -> preterm_in_env

        (* term parser with schema expansion *)
        val -- : term frag list -> 'a -> term

        (* schema specification parser *)
        val -< : term frag list -> 'a -> term
        val >- : int


end;


