(*====================================================================
 *
 * HolTermPatterns
 *
 * type termpattern
 * 	Abstract type of termpatterns.
 * 	To be honest, in the current implementation termpatterns are
 * 	just terms....
 *
 * val string_of_termpattern
 *	Returns the termpattern in a format that can be read by
 *	termpattern_of_string.  Term style syntax is used.  
 *	At the moment string_of_termpattern = string_of_term with
 *	show_types on.
 *
 * val termpattern_of_string
 *	Parse the string from termpattern syntax ( = term syntax
 *	with show_types always on) into a term.
 *
 * val termpattern_of_term 
 *	interprets variables and constants with
 * 	name "_" in the term as wildcard matches.  Variables are
 * 	wildcard matches which are selected, i.e. returned by "match".
 *
 * val termpattern_of_term_quote
 *	Much the same as termpattern_of_term
 *
 * val termpattern_of_preterm 
 *	Theoretically much the same as termpattern_of_term.  Not yet
 *	implemented.
 *
 * val general_matching_termpattern
 *	For a given termpath and term, returns a pattern which
 * 	is a fairly general yet readable selecting termpattern for the path.
 *	Only one non "_" variable ("P" for boolean values, "x" for non
 *	booleans) will occur in the term pattern, except at bound
 *	variables where the formals will occur.  In future formals
 *	may also be replaced by "_"'s.
 *
 *	Constants which are at thehead of a list-comb are kept
 *	in the resulting termpattern.  Removing these would
 *	make the term unreadable.
 *
 * val termpaths_of_pattern
 *	Returns the termpaths selected by variables in the termpattern.
 *	The same variable name can be used to point to more than one
 *	path.
 *	
 * -|, |-
 *	Quotation style parser for termpatterns.
 *
 * use "../tkhol/hol90_termpaths/src/termpatterns.sig";
 * use "../tkhol/hol90_termpaths/src/termpatterns.sml";
 *====================================================================*)
   
signature HolTermPatterns_sig =
sig

   type termpattern; 
   val termpattern_of_string : string -> termpattern;
   val string_of_termpattern : termpattern -> string;
   val termpattern_of_term : term -> termpattern;
   val termpattern_of_term_quote : term frag list -> termpattern;
(*   val termpattern_of_preterm : preterm -> termpattern; *)

   val general_matching_termpattern : (HolTermPaths.termpath * term) -> termpattern;
   val termpaths_of_pattern : termpattern -> HolTermPaths.termpath list
   
   val -| : termpattern frag list -> 'a -> termpattern;
   val |- : int;
   
end;


