(*====================================================================
 *
 * HolTermPaths
 *
 * type termpath
 * 	Data type of navigation markers through HOL terms.
 *
 * val lookup_termpath
 *
 * val PATH_CONV
 *	Apply the conversion at the given location in the term.
 *
 * val PATH_CONV_TAC
 *	Apply the conversion at the given location in the goal.
 *
 * use "../tkhol/hol90_termpaths/src/termpaths.sig";
 * use "../tkhol/hol90_termpaths/src/termpaths.sml";
 *====================================================================*)
 
signature HolTermPaths_sig =
sig
   	
   datatype termbranch = 
   	RATOR | 
   	RAND | 
   	BODY;
      
   type termpath; (* = termbranch list *)
   
   val lookup_branch : termbranch -> term -> term;
   val lookup_path : termpath -> term -> term;
   
end;

