(%--------------------------------------------------------------------------%)
(%                  Copyright (c) Donald Syme 1992                          %)
(%                  All rights reserved                                     %)
(%                                                                          %)
(% Donald Syme, hereafter referred to as `the Author', retains the copyright%)
(% and all other legal rights to the Software contained in this file,       %)
(% hereafter referred to as `the Software'.                                 %)
(%                                                                          %)
(% The Software is made available free of charge on an `as is' basis. No    %)
(% guarantee, either express or implied, of maintenance, reliability,       %)
(% merchantability or suitability for any purpose is made by the Author.    %)
(%                                                                          %)
(% The user is granted the right to make personal or internal use of the    %)
(% Software provided that both:                                             %)
(% 1. The Software is not used for commercial gain.                         %)
(% 2. The user shall not hold the Author liable for any consequences        %)
(%    arising from use of the Software.                                     %)
(%                                                                          %)
(% The user is granted the right to further distribute the Software         %)
(% provided that both:                                                      %)
(% 1. The Software and this statement of rights are not modified.           %)
(% 2. The Software does not form part or the whole of a system distributed  %)
(%    for commercial gain.                                                  %)
(%                                                                          %)
(% The user is granted the right to modify the Software for personal or     %)
(% internal use provided that all of the following conditions are observed: %)
(% 1. The user does not distribute the modified software.                   %)
(% 2. The modified software is not used for commercial gain.                %)
(% 3. The Author retains all rights to the modified software.               %)
(%                                                                          %)
(% Anyone seeking a licence to use this software for commercial purposes is %)
(% invited to contact the Author.                                           %)
(%--------------------------------------------------------------------------%)



(%--------------------------------------------------------------------
 % use "hol90_richtext/pp/hol.pp.sig";
 % use "hol90_richtext/pp/hol.pp.sml";
 %--------------------------------------------------------------------%)

strings for Terminal =
end strings


prettyprinter Hol =

(% Precedence table for HOL types and terms %)

(% Values have been chosen to allow user-defined objects to have a %)
(% precedence between the precedences of any built-in objects.     %)

attributes

   "prod"   300 {infix_tycon};
   "sum"    200 {infix_tycon};
   "fun"    100 {infix_tycon};

   "#appl"                            2000;   (% Function applications %)
   "COND"                              300;   (% Conditionals %)
   "LET"                               200;   (% Let expressions %)
   "#binder"                           100;   (% Binders %)
   ":"                                   0;   (% Type information %)
   s where is_infix(s) -> fixity(s) + 1000;   (% Infixes %)

end attributes


depth = infinity;

parameters
   context = "";
   wrap_terms = false;
   show_types = false;
   show_restrictions = true;
   show_assums = false;
   number_hyp = true;
   goal_line = "";
   first_assum_on_top = true;
end parameters


patterns

   UNOP(op,*arg) = COMB(CONST(op,*),*arg);

   BINOP(op,*arg1,*arg2) = COMB(COMB(CONST(op,*),*arg1),*arg2);

   TUPLE(**comps) = [BINOP(",",*comps,<1..>)]*comps;

   (% The pattern below assumes that terms containing bound variables as    %)
   (% tuples have been converted from the form using "UNCURRY" to a form in %)
   (% which a tuple takes the place of a single bound variable. As a term,  %)
   (% the latter form is not valid, but as a parse-tree it is fine.         %)

   BINDER(op,*varstruct,*body) =
      COMB(CONST(op,*),PABS(*varstruct,*body)) where is_binder(op);

   RESQUAN(op,*pred,*varstruct,*body) =
      COMB(COMB(CONST(op,*),*pred),PABS(*varstruct,*body))
         where is_res_quan(op);

   (% The pattern for LETS loops down a chain of LETs, forming the lists    %)
   (% *argsl and *letbodyl. The data is not in textual order, so the lists  %)
   (% are reversed before returning them. At the end of the chain of LETs   %)
   (% there is a chain of abstractions, the bound variables of which are    %)
   (% the variables being declared. These are in the textual order. After   %)
   (% the chain of abstractions, comes the "in" body (which is bound to     %)
   (% *body).                                                               %)

   (% For each LET in the chain there is a chain of abstractions. The bound %)
   (% variables are the arguments of the identifier being declared, and the %)
   (% body is the body of the declaration. The pattern binds the bodies to  %)
   (% *letbodyl. Each of the abstraction chains is also bound (to *argsl).  %)
   (% The individual arguments cannot be bound because lists of lists are   %)
   (% flattened by the pretty-printer. An attempt to bind the individual    %)
   (% arguments would result in one list of all the arguments to all of the %)
   (% LETs, with no indication of which arguments belong to which LET.      %)

   (% The number of bound variables gathered in *bvl is forced to be the    %)
   (% same as the number of declarations: if any less then the pattern does %)
   (% not match. Any excess is left in *body to be printed later.           %)

   DEC(*args,*letbody) = |*args|[PABS(*,<>)]*letbody;

   LETS(**bvl,**<->argsl,**<->letbodyl,*body) = 
      [BINOP("LET",<1..>,DEC(*argsl,*letbodyl))]
      [PABS(*bvl,<length(**argsl)..length(**argsl)>)]*body;

   (% The elements of a list are obtained from a chain of applications of   %)
   (% the constant "CONS" followed by "NIL".                                %)

   CONS(*x,*xs) = COMB(COMB(CONST("CONS",*),*x),*xs);

   LIST(**elems) = [CONS(*elems,<>)]CONST("NIL",*);

   INSERT(*x,*xs) = COMB(COMB(CONST("INSERT",*),*x),*xs);

   SET(**elems) = [INSERT(*elems,<>)]CONST("EMPTY",*);

end patterns


(% Rules for HOL types %)

rules for type =

   (% Variable types %)

   VARTYPE(op) -> op;

   (% Compound type with an infix constructor %)

   (% Type is enclosed in parentheses if constructor has a lower or the     %)
   (% same precedence as the parent constructor.                            %)

   TYPE(op,*type1.*type2) where op is "infix_tycon" ->
      [lpar{":" ^ op}
       [<hv 1,3,0> [<h 1> (*type1 <= ":" ^ op)
                          if op = "fun" then "->"
                          else if op = "prod" then "#"
                          else if op = "sum" then "+"
                          else op]
                   (*type2 <= ":" ^ op)]
       rpar{":" ^ op}];

   (% All other compound types %)

   TYPE(op,.) -> op;

   TYPE(op,**types.*type) ->
      [<hv 0,3,0> ["(" [<hv 0,++3,0> **[<h 0> **types ","] *type] ")"] op];

end rules


(% Rules for HOL terms %)

rules for term =

   (% Special rule used by printing of let expressions %)

   (% For printing the chain of arguments for each LET in a let expression. %)
   (% The body is thrown away. (It is printed by the main rule for let      %)
   (% expressions. The rule below only matches in the context of having     %)
   (% been called from the main rule. It makes recursive calls to the       %)
   (% printer to print the variables in the normal context for terms.       %)
   (% This rule must come first because the other rules do not look at the  %)
   (% context.                                                              %)

   [PABS(*args,<>)] where context = "in_let_args" ->
      [<h 1> [] **args{context = ""}];

   (% Variables %)

   VAR(var,*type) ->
      if show_types
      then [lpar{":"} [<hv 0,0,0> var [<h 0> ":" *type:type]] rpar{":"}]
      else var;

   (% The constant "NIL" is printed as "[]" %)

   CONST("NIL",*type) ->
      if show_types
      then [lpar{":"} [<hv 0,0,0> "[]" [<h 0> ":" *type:type]] rpar{":"}]
      else "[]";

   (% The constant "EMPTY" is printed as "{}" %)

   CONST("EMPTY",*type) ->
      if show_types
      then [lpar{":"} [<hv 0,0,0> "{}" [<h 0> ":" *type:type]] rpar{":"}]
      else "{}";

   (% Other constants %)

   (% Infixes, binders and ~ are prefixed with "$". %)

   CONST(const,*type) ->
      if show_types 
      then 
       [<hv 0,0,0> if is_infix(const) or is_binder(const) or (const = "~")
                   then ["$" const]
                   else const
                   [<h 0> ":" *type:type]]
      else if is_infix(const) or is_binder(const) or (const = "~")
            then ["$" const]
            else const;

   (% Tuples %)

   (% These are treated separately from other infixes because no space is   %)
   (% to appear between the comma and the components of the pair.           %)

   (% The rule actually deals with tuples represented by nested pairs. This %)
   (% prevents unnecessary bracketing.                                      %)

   TUPLE(**comps.*comp) ->
      [lpar{","}
       [<hv 0,0,0> **[<h 0> (*comps <= ",") ","] (*comp <= ",")]
       rpar{","}];

   (% Lists (see also the rule for the constant "NIL") %)

   (% Lists are not explicitly assigned a precedence. They never need to be %)
   (% enclosed within parentheses because they are already enclosed within  %)
   (% brackets. ";" is given the lowest possible precedence, so the         %)
   (% elements of a list never appear enclosed within parentheses.          %)

   LIST(**elems.*elem) -> ["[" [<hov 0,0,0> **[<h 0> *elems ";"] *elem] "]"];

   (% Enumerated sets (see also the rule for the constant "EMPTY") %)

   SET(**elems.*elem) -> ["{" [<hov 0,0,0> **[<h 0> *elems ";"] *elem] "}"];

   (% Set abstractions %)

   COMB(CONST("GSPEC",*),PABS(*varstruct,BINOP(",",*elem,*spec)))
      where common_frees(varstruct,elem,spec) ->
      ["{" [<hv 1,3,0> [<h 1> *elem "|"] *spec] "}"];

   (% Right associative operators %)

   (% These are dealt with separately from other infixes so that            %)
   (% unnecessary levels of parentheses can be omitted. To avoid            %)
   (% ambiguities, the normal rule for infixes inserts parentheses when two %)
   (% operators of the same precedence occur together. If the two operators %)
   (% are the same, and the operator is associative, the ambiguity can only %)
   (% be in the structure, not in the meaning.                              %)

   (% The rule deals with not just two operators, but a whole chain of      %)
   (% them. If the sub-expressions do not fit on one line, they appear      %)
   (% vertically, each but the last being followed by the operator.         %)

   (% Currently assumes all infixes are right associative.                  %)

   [BINOP(op,*args,<1..:op>)]*arg where is_infix(op) ->
      [lpar{op}
       [<hov 1,0,0> **[<hv 1,0,0> (**args <= op) op] (*arg <= op)]
       rpar{op}];

   (% Infixes %)

   (% Note that rules which deal with more specialised infixes appear       %)
   (% before this rule so as to have priority over it.                      %)

   BINOP(op,*arg1,*arg2) where is_infix(op) ->
      [lpar{op} [<hv 1,3,0> [<h 1> (*arg1 <= op) op] (*arg2 <= op)] rpar{op}];

   (% Rule for "~" %)

   (% This is dealt with separately from other prefixes because no space    %)
   (% is to appear between the "~" and its argument.                        %)

   UNOP("~",*arg) -> [lpar{"~"} "~" (*arg <= "~") rpar{"~"}];

   (% Binders %)

   (% When a binder is applied to an abstraction, the name of the binder    %)
   (% replaces the lambda. This rule deals with nested bindings, pulling    %)
   (% the bound variables into a list. The name of the binder is displayed  %)
   (% only once, followed by the bound variables separated by spaces,       %)
   (% followed by a dot and the body of the binding.                        %)

   (% To ensure that a tuple of variables is enclosed within parentheses,   %)
   (% the recursive call is made with the highest precedence. Single        %)
   (% variables will not appear in parentheses because the rule for         %)
   (% variables ignores precedence.                                         %)

   [BINDER(op,*bvs,<1..:op>)]*body ->
      [lpar{"#binder"}
       [<hv 1,3,0> [<h 0> (pad_binder(op)) [<hv 1,0,0> (**bvs)] "."]
                   (*body < "#binder")]
       rpar{"#binder"}];

   (% Restricted quantifiers %)

   [RESQUAN(op,*pred,*bvs,<1..:op,pred>)]*body where show_restrictions ->
      [lpar{"#binder"}
       [<hv 1,3,0> [<h 0> (pad_binder(restriction_name(op)))
                          [<hv 1,0,0> (**bvs)]
                      <1> "::"]
                   [<h 0> (*pred) "."]
                   (*body < "#binder")]
       rpar{"#binder"}];

   (% Abstractions %)

   (% The lambda of abstractions is allocated a precedence. The rule is     %)
   (% analogous to the one for binders. See the comments for that rule.     %)

   [PABS(*bvs,<1..>)]*body ->
      [lpar{"#binder"}
       [<hv 1,3,0> [<h 0> "\\" [<hv 1,0,0> (**bvs)] "."] (*body < "#binder")]
       rpar{"#binder"}];

   (% Conditionals %)

   (% All three sub-expressions are printed subject to the precedence of %)
   (% the `COND' constant.                                               %)

   COMB(COMB(COMB(CONST("COND",*),*cond),*x),*y) ->
      [lpar{"COND"}
       [<hov 1,0,0> [<hv 1,0,0> (*cond <= "COND") "=>"]
                    [<hv 1,0,0> (*x <= "COND") "|"]
                    (*y <= "COND")]
       rpar{"COND"}];

   (% Let expressions %)

   (% The identifiers declared in the let expression and the names of their %)
   (% arguments are printed subject to the highest precedence. This ensures %)
   (% that they are enclosed within parentheses if they are in fact tuples  %)
   (% rather than single variables.                                         %)

   LETS(*bv.**bvl,*args.**argsl,*letbody.**letbodyl,*body) ->
      [lpar{"LET"}
       [<hov 1,0,0>
           [<hv 1,3,0>
               [<h 1> "let" (*bv) <0> (*args){context = "in_let_args"} "="]
               (*letbody <= "LET")]
           **[<hv 1,3,0> **[<h 1> "and" (**bvl)
                              <0> (**argsl){context = "in_let_args"} "="]
                         (**letbodyl <= "LET")]
           [<h 1> "in" (*body <= "LET")]]
       rpar{"LET"}];

   (% Function applications. %)

   (% Every application not covered by a preceding rule is dealt with by  %)
   (% this one. The precedence used is that of the null string. The       %)
   (% precedence table assigns the highest precedence to anything it does %)
   (% not recognise. Thus user defined functions have the highest         %)
   (% precedence. So, the arguments to the function appear in parentheses %)
   (% unless they are just identifiers. This rule deals with functions    %)
   (% applied to one or more arguments. Note that the pattern binds the   %)
   (% arguments in the reverse of the textual order, so the list has to   %)
   (% be reversed before printing.                                        %)

   [COMB(<1..>,*rands)]*rator ->
      [lpar{"#appl"}
       [<hv 1,3,0> (*rator <= "#appl") (**<->rands <= "#appl")]
       rpar{"#appl"}];

end rules


(% Rules for HOL theorems %)

rules for thm =

   (% Theorem with at least one hypothesis %)

   THM(**hyps.*hyp,*concl) ->
      if show_assums
      then [<hov 1,0,0> **[<h 0> **hyps:term ","]
                        *hyp:term
                        [<h 1> "|-" *concl:term]]
      else [<h 1> (replicate(".",length(**hyps) + 1)) "|-" *concl:term];

   (% Theorem with no hypotheses %)

   THM(.,*concl) -> [<h 1> "|-" *concl:term];

end rules


rules for hyp =
    HYPOTH(num,*hyp) ->
        [<h 1> if number_hyp then [num] else []
               "[" 
               if wrap_terms then ["--`"] else []
               *hyp:term
               if wrap_terms then ["`--"] else [] 
               "]"];
end rules

rules for goal =

   (% Goal with at least one hypothesis %)

   GOAL(**hyps,*concl) ->
      [<v 4,0> 
         [<h 0> if wrap_terms then ["--`"] else [] 
                *concl:term 
                if wrap_terms then ["`--"] else []]
         <0,0> goal_line
       **[<h 0> if first_assum_on_top then **hyps:hyp else **<->hyps:hyp]
(%         **[<h 0> **<->hyps:hyp] else **[<h 0> **hyps:term] %)
      ];

   (% Goal with no hypotheses %)

   GOAL(.,*concl) -> 
      [<v 0,0> 
         [<h 0> if wrap_terms then ["--`"] else []  
                *concl:term 
                if wrap_terms then ["`--"] else []
         ]
      ];

end rules


end prettyprinter


