(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




signature ScriptFragments_sig = sig
 
    structure Ast : sig type dec type exp end;
    sharing Ast = System.Ast;
    structure BwdProofs : BwdProofs_sig;
    type data; (* = exn *)

    type fragment
    val mk_fragment : {
          describe : string,
          edit_tool : string,
          data : data,
          pseudonyms : string list
        } -> fragment
    val dest_fragment : fragment -> {
          origin : (string * (int * int)) option,
          describe : string,
          edit_tool : string,
          data : data,
          pseudonyms : string list
        }


    type fragment_matcher (* = dec -> fragment *)
    val mk_fragment_matcher : (Ast.dec -> fragment) -> fragment_matcher
    val dest_fragment_matcher : fragment_matcher -> (Ast.dec -> fragment)

    val new_matcher : fragment_matcher -> unit

    (* helpful utility routines for writing new matches *)
    val lookup_record : string -> Ast.exp -> Ast.exp
    val bwdproof_of_exp : Ast.exp -> BwdProofs.bwdproof
    val match : Ast.dec -> fragment

    val collapseLocals : bool ref

    datatype analysis = ERRORS of string | FRAGMENTS of fragment list
    val analyse_file : string -> analysis
    val analyse_string : string -> analysis

   
    (*-----------------------------------------------------------------------
     * HOL-specific matchers.  Should all be in seperate structures.
     *---------------------------------------------------------------------*)

    val match_load_library : fragment_matcher
    val match_close_theory : fragment_matcher
    val match_new_theory : fragment_matcher
    val match_load_theory : fragment_matcher
    val match_extend_theory : fragment_matcher
    val match_export_theory : fragment_matcher

    exception DATA_IS_FOR_NEW_TYPE_DEFINITION of {name:string,pred:string,inhab_thm:string}
    val data_for_new_type_definition : data -> {name:string,pred:string,inhab_thm:string}
    val match_new_type_definition : fragment_matcher
    val new_type_definition_frag : {name:string,pred:string,inhab_thm:string} -> fragment

    exception DATA_IS_FOR_DEFINE_TYPE of {name:string,fixities:string list,type_spec:string} 
    val data_for_define_type : data -> {name:string,fixities:string list,type_spec:string} 
    val match_define_type : fragment_matcher
    val define_type_frag : {name:string,fixities:string list,type_spec:string} -> fragment

    exception DATA_IS_FOR_NEW_RECURSIVE_DEFINITION of {def:string, fixity:string, name:string, rec_axiom:string} 
    val data_for_new_recursive_definition : data -> {def:string, fixity:string, name:string, rec_axiom:string} 
    val match_new_recursive_definition : fragment_matcher
    val new_recursive_definition_frag : {def:string, fixity:string, name:string, rec_axiom:string} -> fragment

    exception DATA_IS_FOR_NEW_DEFINITION of {fixity: string, def:string, name:string}
    val data_for_new_definition : data -> {fixity : string, def:string, name:string}
    val match_new_definition : fragment_matcher
    val new_definition_frag : {fixity : string, def:string, name:string} -> fragment

    exception DATA_IS_FOR_BWDPROOF of {theory: string option, name: string,goal: string, proof: BwdProofs.bwdproof}
    val data_for_bwdproof : data -> {theory: string option, name: string,goal: string, proof: BwdProofs.bwdproof}
    val match_bwdproof : fragment_matcher
    val bwdproof_frag : {theory: string option, name: string,goal: string, proof: BwdProofs.bwdproof} -> fragment

    exception DATA_IS_FOR_FWDPROOF of {save: bool, name: string,derivation: Ast.exp}
    val data_for_fwdproof : data -> {save: bool, name: string,derivation: Ast.exp}
    val match_fwdproof : fragment_matcher

end;
