
#----------------------------------------------------------------------------
# ProofsPP::ProcessArgs
#
#       -norichtext     turn rich text output off.  Automatically off
#                       for hol90.
#
#----------------------------------------------------------------------------

proc ProofsPP::ProcessArgs { argc argv } {
        global ProofsPP_flags

   if {[llength [info commands Preferences_Add]]==1} {

    Preferences_Add "Proof Display" \
"Preferences related to the formatting of HOL proofs may be \
specified here.  Interface maps dictate the fonts and colors that \
proofs will be displayed in." [list \
        [list ProofsPP_flags(mapsOnByDefault) proofsInterfaceMapping BOOL 1 "Use Interface Maps by Default" "Whether TkHolWorkbench should use interface maps by default for proofs."] \
        \
        [list ProofsPP_flags(interfaceMaps) proofsInterfaceMaps STRING [list ProofsTk] "ProofsPP Interface Maps" "The interface maps to use when displaying Richtext. These are specified below. "] \
        [list ProofsPP_flags(interface_map,ProofsTk) ProofsTk INTERFACE_MAP [list \
            [list [list HARD]   {}              Teletype-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-*] \
            [list [list SOFT]   {}              Teletype-Medium-R-Normal-Normal|*-*-*-*-DodgerBlue3-*-*-*-*] \
            [list default       {}              Teletype-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-*] \
        ] \
        "ProofTk Interface Map" \
"The interface map used for formatting proofs."] \
      ]


   }

        set ProofsPP_flags(goal_line) ""
        set ProofsPP_flags(wrap_terms) 0

        for {set arg 0} {$arg < $argc} {incr arg} {
            if {[lindex $argv $arg]=="-norichtext"} {
                set ProofsPP_flags(richtext) 0
            }
        }
}


proc ProofsPP::InitialisePackage { } {
        global ProofsPP_flags
        set ProofsPP_flags(structuredtext_loaded) 0
}


proc ProofsPP::delayedLoadStructuredText { } {
        global ProofsPP_flags 

        if !$ProofsPP_flags(structuredtext_loaded) {
            RichText::installInterfaceMap ProofsTk $ProofsPP_flags(interface_map,ProofsTk)
            set ProofsPP_flags(structuredtext_loaded) 1
        }
}



