(%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)
(%                                                                          %)
(%               Copyright 1994, 1995 University of Cambridge               %)
(%                                                                          %)
(%                           All rights reserved.                           %)
(%                                                                          %)
(%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)


(% 
new_theory "myZ";
Globals.library_path := ("hol90_Z/"::(!Globals.library_path));;
prim_load_library Lib.interpret {lib=find_library "Z",theory="-"};;
unset Z_flags(interface_map,ZTk)
source ../hol90_Z/interface/load.tcl
Z::ProcessArgs 0 {}
RichText::installInterfaceMap BaseLogicTk \
	$RichText_flags(interface_map,BaseLogicTk)
RichText::installInterfaceMap SetsTk \
	$RichText_flags(interface_map,SetsTk)
RichText::installInterfaceMap ZTk $Z_flags(interface_map,ZTk)
use "../hol90_Z/src/Z.sig"; use "../hol90_Z/src/Z.sml";
use "../hol90_Z/pp/Z.pp.support.sml";  
use "../hol90_Z/pp/hol_and_Z.pp.sml";  structure Richtext=RICHTEXT(HOLPP);

ZExternals.set_abbreviate_schemas false;
ZExternals.set_abbreviate_schemas true;
ZExternals.set_extract_schemas false;
ZExternals.set_extract_schemas true;

-------------
BOTH (
(\(known,birthday,known',birthday',nameI,dateI).
  AddBirthday (known,birthday,known',birthday',nameI,dateI) ZAND
  FindBirthday (known,birthday,known',birthday',nameI,dateO)
) (known,birthday,known',birthday',nameI,dateI))

--> 

BOTH (AddBirthday /\ FindBirthday)
-------------

%)

prettyprinter Hol =

depth = infinity;

patterns

   ZAPPLY(*f,*a) = COMB(COMB(CONST("ZAPPLY",*),*f),*a);
   PRED_SET(*ty) = TYPE("fun",*ty.TYPE("bool",.));
   NN_1() =
      CONST("NN_1",*);

end patterns

rules for type =
   PRED_SET(*ty) -> [<h 0> "(" *ty ")set"];
end rules

rules for term =
   
   NN_1() -> if (subscriptZ()) then [<h 0> "NN" "SUBSCRIPT1"] else [<h 0> "NN_1"];

   DELTA(*schema) -> [lpar{"DELTA"} [<hov 0,3,0> "DELTA" *schema] rpar{"DELTA"}];
   XI(*schema) -> [lpar{"XI"} [<hov 0,3,0> "XI" *schema] rpar{"XI"}];
   SCHEMA_USAGE(*schema) -> [<h 0> *schema];
   ZAPPLY(*f,*a) -> [<hov 1,1,0> *f *a];

   SCHEMA(**schemas,**decs,**body) ->		
         [<v 0,0>        ""
                         "+-----------------------------"
		**[<h 0> "|" <1> *schemas]
		**[<h 0> "|" <1> *decs]
                  [<h 0> "+----------"]
                **[<h 0> "|" <1> *body]
                         "+-----------------------------"
         ];

   (%--------------- from hol.pp ----------------%)

   (% Binders %)

   (% When a binder is applied to an abstraction, the name of the binder    %)
   (% replaces the lambda. This rule deals with nested bindings, pulling    %)
   (% the bound variables into a list. The name of the binder is displayed  %)
   (% only once, followed by the bound variables separated by spaces,       %)
   (% followed by a dot and the body of the binding.                        %)

   (% To ensure that a tuple of variables is enclosed within parentheses,   %)
   (% the recursive call is made with the highest precedence. Single        %)
   (% variables will not appear in parentheses because the rule for         %)
   (% variables ignores precedence.                                         %)


   [SCHEMA_BINDER(op,*bvs,<1..:op>)]*body ->
      [lpar{"#binder"}
       [<hv 1,3,0> [<h 0> (pad_binder(op)) [<hv 1,0,0> (**bvs)] "."]
                   (*body < "#binder")]
       rpar{"#binder"}];

   (% Right associative operators %)

   (% These are dealt with separately from other infixes so that            %)
   (% unnecessary levels of parentheses can be omitted. To avoid            %)
   (% ambiguities, the normal rule for infixes inserts parentheses when two %)
   (% operators of the same precedence occur together. If the two operators %)
   (% are the same, and the operator is associative, the ambiguity can only %)
   (% be in the structure, not in the meaning.                              %)

   (% The rule deals with not just two operators, but a whole chain of      %)
   (% them. If the sub-expressions do not fit on one line, they appear      %)
   (% vertically, each but the last being followed by the operator.         %)

   (% Currently assumes all infixes are right associative.                  %)

   [SCHEMA_BINOP(op,*args,<1..:op>)]*arg where is_infix(op) ->
      [lpar{op}
       [<hov 1,0,0> **[<hv 1,0,0> (**args <= op) op] (*arg <= op)]
       rpar{op}];


end rules

rules for thm =
   SCHEMA_DEFINITION(*con,SCHEMA(**schemas,**decs,**body)) ->
         [<v 0,0> [<h 1> "+-" *con:term "--------------"]
		**[<h 0> "|" <1> *schemas:term]
		**[<h 0> "|" <1> *decs:term]
                  [<h 0> "+----------"]
                **[<h 0> "|" <1> *body:term]
                         "+-----------------------------"
         ];
end rules


end prettyprinter
