#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc Tcl { w args } {
    toplevel $w
    wm minsize $w 1 1
    wm title $w "Tcl Shell"
    pack [frame $w.f] -side top -expand yes -fill both
    scrollbar $w.f.s -orient vert -command "$w.f.shell.text yview"
    eval [list shell $w.f.shell -yscroll "$w.f.s set" -height 12] $args
    pack $w.f.s -side right -fill y
    pack $w.f.shell -side left -fill both -expand yes
    
    update idletasks
    wm deiconify $w     
    tkwait visibility $w
    if {[llength [info commands focus_goToFirst]]>=1} {
        focus_goToFirst $w.f.shell.text
    } else {
        focus $w.f.shell.text
    }  
        update
}


