#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc preferences { args} {
        global pref
        global gui_flags

        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i] -group {
                incr i
                set group [lindex $args $i]
            } default {
                error "unrecognized arg [lindex $args $i]"
            }
        }
        
        set id $group
        
    global pref env
    set ix [lsearch $pref(panes) $id]
    if {$ix < 0} {
        return
    }
    set w .pref$ix
    if [catch {toplevel $w}] {
        wm deiconify $w
        raise $w
        
    } else {
        wm withdraw $w
        global gui_flags
        wm title $w "$id Preferences"
        pack [frame $w.but] -side bottom -padx 10 -pady 10
        wm protocol $w WM_DELETE_WINDOW [list preferences::dismiss $ix]
        pack [fontcheck button $w.but.reset \
                -text Reset \
                -command "PreferencesReset [list $id]"] \
            -side left
        pack [fontcheck button $w.but.save \
                -text "Save" \
                -command "PreferencesRecordEntryChanges [list $id]; PreferencesSave [list $id]"] \
            -side left
        pack [fontcheck button $w.but.close \
                -text Close \
                -command "PreferencesRecordEntryChanges [list $id]; preferences::dismiss [list $ix]"] \
            -side left
        wm minsize $w 25 2
        pack [frame $w.help \
                -borderwidth 2 \
                -relief sunken] \
            -expand yes -fill both
                      
        pack [fontcheck scrollable text $w.help.text \
                -height 8 \
                -font $gui_flags(font,helptext) \
                -wrap word] -expand yes -fill y
        set txt $w.help.text.b
        $txt insert 1.0 $pref($id,text)
        set maxWidth 0
        foreach item $pref($id,prefs) {
            set len [string length [PrefComment $item]]
            if {$len > $maxWidth} {
                set maxWidth $len
            }
        }
        foreach item $pref($id,prefs) {
            preferences::dialog_item $w $item $maxWidth
            $txt insert end "\n\n[PrefComment $item]\n\t[PrefHelp $item]"
        }
        $txt configure -state disabled
        update
        wm deiconify $w
        tkwait visibility $w
        update
    }
    
    focus_goToFirst $w
}


proc preferences::next { ix {i 1}} {
    global pref
    set geo [string trimleft [wm geometry .pref$ix] -x0123456789]
    destroy .pref$ix
    catch {preferences::nuke_item_help .prefitemhelp}
    incr ix $i
    set id [lindex $pref(panes) $ix]
    if {$id != {}} {
        PreferencesSectionDialog $id
        wm geometry .pref$ix $geo
    }
}

proc preferences::dialog_item { frame item width } {
        global gui_flags
        global pref
        incr pref(uid)
        set f [frame $frame.p$pref(uid)]
        pack $f -side top -fill both
        pack [fontcheck label $f.label \
                -text [PrefComment $item] \
                -width $width \
                -font $gui_flags(font,labels)] \
            -side left -fill both
        bind $f.label <1> "preferences::item_help  %W %X %Y [list $item]"

        set type [PrefType $item]
        set default [PrefDefault $item]
    switch -regexp --  $type {
        CHOICE.* {
            foreach choice [lrange $type 1 end] {
                incr pref(uid)
                pack [fontcheck radiobutton $f.c$pref(uid) \
                        -text $choice \
                        -value $choice \
                        -variable [PrefVar $item] \
                        -relief flat] \
                    -side left
            }
        }
        ^(LIST|INTERFACE_MAP)\$ {
            pack [listedit $f.listedit \
                        -variable [PrefVar $item]] \
                    -side left -fill both -expand yes -pady 10
            $f.listedit listbox config -width 40 -height 5

        }
        BOOL { 
            set varname [PrefVar $item]
            pack [fontcheck checkbutton $f.check \
                    -text "On" \
                    -variable $varname \
                    -relief flat \
                    -command [list preferences::bool_fixup $f.check $varname]] \
                -side left
            preferences::bool_fixup $f.check $varname
        } 
        default {
            # This is a string or numeric
            pack [fontcheck entry $f.entry \
                    -width 10 -relief sunken \
                    -font $gui_flags(font,textentry)] \
                -side left -fill both -expand yes
            set pref(entry,[PrefVar $item]) $f.entry

            set varname [PrefVar $item]
            $f.entry insert 0 [uplevel #0 [list set $varname]]
            bind $f.entry <Return> [list PrefEntrySet %W $item]
        }
    }
}
proc preferences::bool_fixup { check varname } {
    upvar #0 $varname var
    if {$var} {
        $check config -text On
    } else {
        $check config -text Off
    }
}
proc preferences::item_help { parent x y item } {
    global pref
    global gui_flags
    catch {destroy .prefitemhelp}
    set text [PrefHelp $item]
    if {$text == {}} {
        return
    }
    set self [toplevel .prefitemhelp]
    wm title .prefitemhelp "Item help" 
    wm geom .prefitemhelp +[expr $x+10]+[expr $y+10]
    wm transient .prefitemhelp [winfo toplevel $parent]
    wm group .prefitemhelp [winfo toplevel $parent] 
    pack [message $self.msg -text $text -aspect 1500 -font $gui_flags(font,helptext)]
    bind $self.msg <1> {preferences::nuke_item_help .prefitemhelp}
    tkwait visibility .prefitemhelp
}
proc preferences::nuke_item_help { t } {
    global pref
    destroy $t
}


proc preferences::dismiss {{ix {}}} {
    global pref
    catch {destroy .pref$ix}
    catch {preferences::nuke_item_help .prefitemhelp}
    if {$ix == {}} {
        catch {destroy .prefhelp}
        set ix 0
        foreach id $pref(panes) {
            catch {destroy .pref$ix}
            incr ix
        }
    }
}
        
