#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc feedback::ProcessArgs { argc argv } {

        global busy 
        global feedback
        global feedback_vals

        global gui_flags
        global busy_vals
        set busy_vals(old_busy) 0

        wm geometry . 1x1
        wm transient .

        pack [frame .f -relief sunken -borderwidth 2]
        pack [fontcheck label .feedback  \
                -font -Adobe-Helvetica-Bold-R-Normal-*-*-100-* \
                -height 4 \
                -width 50 \
                -wraplength 200 \
                -justify center \
                -anchor center] \
            -expand yes -fill x -in .f -padx 5 -pady 30
        feedback::deiconify

        set feedback_vals(last_win) .
        set feedback_vals(altered_feedbacks) ""

        trace variable busy w busy::set_happened
        set busy 0
        trace variable feedback w feedback::set_happened

        set feedback [list .f "Loading..."]
}

proc feedback::use_window? { w } {
        if {$w==""} { return 0 }
        if ![winfo exists $w] { return 0 }
        if ![winfo ismapped [winfo toplevel $w].feedback] { return 0 }
        return 1
}

        # Compute the window to place the feedback in.  The strategy
        # is:
        #       - Use the feedback window related to the
        #       window given in the feedback value if it exists and
        #       is mapped.
        #       - Use the feedback window related to the
        #       window where the focus currently is if it exists and
        #       is mapped.
        #       - Look through all windows which have previously been
        #       used as feedback windows in a random order, finding
        #       one that exists and is mapped.
        #       - Use the main window ".feedback" if all else fails.

proc feedback::set_happened {arg1 arg2 arg3 } {
        global feedback
        global feedback_vals
        global feedback_wins

    if [catch {
        set win [lindex $feedback 0]
        set text [lindex $feedback 1]


        if [catch {set win [winfo toplevel [lindex $feedback 0]].feedback}] { 
            set win "" 
        }
        if [feedback::use_window? $win] {
            set new_feedback_win $win
            set feedback_wins($win) 1
        } else {
            if [catch {set win [winfo toplevel [focus]].feedback}] { 
                set win "" 
            }
            if [feedback::use_window? $win] {
                set new_feedback_win $win
                set feedback_wins($win) 1
            } else {
                foreach win [array names feedback_wins] {
                    if [feedback::use_window? $win] {
                        set new_feedback_win $win
                        break
                    } else {
                        unset feedback_wins($win)
                    }
                }
            }
            if ![info exists new_feedback_win] { 
                set new_feedback_win .feedback
            }
            
        }
        
        # At this point we have definitely decided which
        # feedback window to use (i.e. $new_feedback_win).
        # If this is different to the last one then we
        # have to do a few things, like change who has the grab
        # pop . up/down according to need.
        #
        if {$feedback_vals(last_win)!=$new_feedback_win} {
                catch {grab release $feedback_vals(last_win)}
                if {$feedback_vals(last_win)==".feedback"} {
                     wm withdraw .
                }
                # catch since other application may have grab
                catch {grab set $new_feedback_win}
                set feedback_vals(last_win) $new_feedback_win
        }
        if {$new_feedback_win==".feedback" && [wm state .]=="withdrawn"} {
            feedback::deiconify
        }
        global busy
        incr busy 1

#       puts "win = \{$win\}, grab = [grab current]"

        $feedback_vals(last_win) config -text $text
        lappend feedback_vals(altered_feedbacks) $feedback_vals(last_win)
        update idletasks 

        after 1 {
            global busy
            incr busy -1
        }
    } error] { global errorInfo; puts "warning in feedback: $errorInfo" }
}


proc busy::set_happened {arg1 arg2 arg3 } {
        global busy feedback 
        global busy_vals
        global feedback_vals

        global gui_flags
        if {$busy<0} {
#           puts stderr "Warning: $gui_flags(title) internal error: busy set below 0"
            set busy 0
            return
        }
        
#       puts "busy_vals(old_busy) = $busy_vals(old_busy), busy = $busy, feedback_vals(last_win) = $feedback_vals(last_win), grab current = [grab current]"

        if {$busy_vals(old_busy)==0 && $busy==1} {
        # If feedback is being sent to ., then 
        # withdraw the window, then update all the geometry information
        # so we know how big it wants to be, then center the window in the
        # display and de-iconify it.

            foreach win [info commands .*] {
                catch {[winfo toplevel $win] config -cursor watch}
            }
        } 
#       if {![info exists busy_vals(old_focus)] && [focus]!="none"} {
#           set busy_vals(old_focus) [focus]
#           # focus none              -- Tk 3.6
#       }
        catch {grab set $feedback_vals(last_win)}
        if {$busy_vals(old_busy)>0 && $busy == 0} {
            foreach afw $feedback_vals(altered_feedbacks) {
                catch {$afw config -text "Ready..."}
            }
            set feedback_vals(altered_feedbacks) ""
            foreach win [info commands .*] {
                catch {[winfo toplevel $win] config -cursor {}}
            }
            catch {wm withdraw .}
            catch {grab release $feedback_vals(last_win)}
#           if [info exists busy_vals(old_focus)] {
#               puts "focus = [focus], busy_vals(old_focus) = $busy_vals(old_focus)"
#               if {[focus]==""} {
#                   catch {focus $busy_vals(old_focus)}
#               }
#               unset busy_vals(old_focus)
#           }
        } 
        set busy_vals(old_busy) $busy
}

proc feedback::deiconify { } {
              set w .
              if {[wm state $w] != "normal"} {
                wm withdraw $w
                set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
                    - [winfo vrootx $w]]
                set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
                    - [winfo vrooty $w]]
                wm geom $w 312x126+$x+$y
                wm deiconify $w
                raise .
                update idletasks
              }
}

