

%{

#define OTHER 257
#define END_OF_DECL 258
#define RETURN(x) { return x; }

static int comment_depth, nested_brackets, nested_braces, nested_paren;

%}


%x NESTED_COMMENT STRING TERM QUOTE

%%


"(*"			{ BEGIN(NESTED_COMMENT); comment_depth = 1; }
[ \t\n\r]+              {  }
<NESTED_COMMENT>"(*"    { comment_depth++; }
<NESTED_COMMENT>"*)"    { comment_depth--; 
                          if (comment_depth == 0) { 
                              BEGIN(INITIAL); 
                          }
                        }
<NESTED_COMMENT><<EOF>> { printf("unmatched open comment\n"); exit(1); }
<NESTED_COMMENT>.       { }

\"                      { BEGIN(STRING); }
<STRING>\"              { BEGIN(INITIAL); RETURN(OTHER); }            
<STRING>\\\"            { }            
<STRING><<EOF>>         { printf("unclosed string\n"); exit(1); }            
<STRING>.               { }            

\`                      { BEGIN(QUOTE); }
<QUOTE>\`              { BEGIN(INITIAL); RETURN(OTHER); }            
<QUOTE><<EOF>>         { printf("unclosed quote\n"); exit(1); }            
<QUOTE>.               { }            

\;+                     { if (nested_paren == 0 && nested_brackets == 0 && nested_braces == 0) { RETURN(END_OF_DECL); } }
"("                     { nested_paren++; RETURN(OTHER); }
")"                     { nested_paren--; if (nested_paren < 0) nested_paren = 0; RETURN(OTHER); }
"{"                     { nested_braces++; RETURN(OTHER); }
"}"                     { nested_braces--; if (nested_braces < 0) nested_braces = 0; RETURN(OTHER); }
"["                     { nested_brackets++; RETURN(OTHER); }
"]"                     { nested_brackets--; if (nested_brackets < 0) nested_brackets = 0; RETURN(OTHER); }

.                       { RETURN(OTHER); }

%%

int main( argc, argv )
int argc;
char **argv;
{
        int count,token,last_token;

        nested_brackets = nested_braces = nested_paren = count = 0;
        last_token = END_OF_DECL;
        while (token = yylex()) {
            if (token==END_OF_DECL) { count++; }
            last_token=token;
        }
        if (last_token == END_OF_DECL) {
            printf("%d\n", count);
        } else {
            printf("last command was not completed\n"); 
            return 1; 
        }
        return 0;
}

