#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc Scripts::current_script { } {
        Scripts::script_for_theory [ML "current_theory()"]
}

proc Scripts::script_for_theory { theory } {
        global TkHol_flags
        regsub %F $TkHol_flags(scriptPattern) $theory file
        return ./$file
}

proc Scripts::add_to_script { code } {
        global gui_flags
        global TkHol_flags
        set script [Scripts::current_script]
        set f [open $script a]
        if $TkHol_flags(addHeadersToScripts) {
            puts $f "(*-----------------------------------------------------------------"
            puts $f " * created using $gui_flags(title), [exec date]"
            puts $f " *-----------------------------------------------------------------*)"
            puts $f " "
        }
        puts $f $code
        puts $f " "
        close $f
        foreach trace $TkHol_flags(script_traces) {
            if {[file tail [lindex $trace 0]]==[file tail $script]} {
                if [catch {[lindex $trace 1]::script_change_notify [lindex $trace 2] $script} err] {
                    global errorInfo
                    puts stderr "warning in Scripts::add_to_script : $errorInfo"
                }
            }
        }
}


proc Scripts::register_trace_for_script { script class obj } {
        global TkHol_flags
        lappend TkHol_flags(script_traces) [list $script $class $obj]
}


proc Scripts::deregister_trace_for_script { script class obj } {
        global TkHol_flags
        set new_traces ""
        foreach trace $TkHol_flags(script_traces) {
            if {$trace!=[list $script $class $obj]} {
                lappend new_traces $trace
            }
        }
        set TkHol_flags(script_traces) $new_traces
}


proc hol88 { } {
    return [cml]
}

proc hol90 { } {
    return [sml]
}                                      


proc hol_load_library { lib } {
#       if [hol88] { ML -log 1 -check 1 -type any "load_library [ml_string $lib]" }
#       if [hol90] { ML -log 1 -check 1 -type any "prim_load_library Lib.interpret \{ lib=(find_library [ml_string $lib]), theory=[ml_string -] \}"  }
        ML -log 1 -check 1 -type any "prim_load_library Lib.interpret \{ lib=(find_library [ml_string $lib]), theory=[ml_string -] \}"
}

proc hol_type_var { n } {
        set var ""
#       if [hol88] {
#           return *$n
#        }
#       if [hol90] {
#           case $n 1 { return 'a } 2 { return 'b } 3 { return 'c }
#        }
        case $n 1 { return 'a } 2 { return 'b } 3 { return 'c }
}

proc hol_ancestry { } {
#       if [hol88] {
#           return "ancestry ()"
#       }
#       if [hol90] {
#           set ancestors "(current_theory()::ancestry (current_theory()))"
#           return $ancestors   
#       }
        return "(current_theory()::ancestry (current_theory()))"
}
proc hol_ancestors { } {
#       if [hol88] { return "ancestors" }
#       if [hol90] { return "ancestry" }
        return "ancestry"
}

proc hol_descendants { } {
#       if [hol88] { 
#               return "(\\thr. filter (\\desc. mem thr (ancestors desc)) (ancestry ()))"
#       }
#       if [hol90] { 
#               return "(fn thr => filter (fn desc =>  mem thr (ancestry desc)) ((ancestry [ml_string -])@\[current_theory()\]))"
#       }
        return "(fn thr => filter (fn desc =>  mem thr (ancestry desc)) ((ancestry [ml_string -])@\[current_theory()\]))"
}

proc hol_thryext {  } { 
#       if [hol88] { return th }
#       if [hol90] { return thms }
        return thms
}


proc hol_term { t } { 
#       if [hol88] { return \"$t\" }
#       if [hol90] { return "(--`$t`--)" }
        return "(--`$t`--)"
}

proc hol_determ { t } { 
        if {[string range $t 0 3]=="(--`"} { set t [string range $t 4 end] }
        if {[string range $t 0 2]=="--`"} { set t [string range $t 3 end] }
        set len [string length $t]
        if {[string range $t [expr $len-4] [expr $len-1]]=="`--)"} { set t [string range $t 0 [expr $len-5]] }
        if {[string range $t [expr $len-3] [expr $len-1]]=="`--"} { set t [string range $t 0 [expr $len-4]] }
        return $t       
}

proc hol_type { t } { 
#       if [hol88] { return \":$t\" }
#       if [hol90] { return "(==`:$t`==)" }
        return "(==`:$t`==)"
}

proc hol_flatten {  } { 
#       if [hol88] { return flat }
#       if [hol90] { return flatten }
        return flatten
}


