#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc sensitive args {
        set argc [llength $args]
        set passon_args ""
        for {set i 0} {$i < $argc} {incr i} {
            case [lindex $args $i] {
                {-sensitivevar -sensitivevars -sensitiveexpr} { incr i }
                default { lappend passon_args [lindex $args $i] }
            }
        }
        # puts "passon_args = $passon_args"
        # puts "args = $args"
        set w [eval $passon_args]
        eval [list make_sensitive $w] $args
}

proc make_sensitive {w args} {
        set argc [llength $args]
        set passon_args ""
        for {set i 0} {$i < $argc} {incr i} {
            switch -- [lindex $args $i] -sensitivevar {
                incr i
                lappend sensitivevars [lindex $args $i]
            } -sensitivevars {
                incr i
                eval lappend sensitivevars [lindex $args $i]
            } -menuentry {
                incr i
                set menuentry [lindex $args $i]
            } -sensitiveexpr {
                incr i
                set sensitiveexpr [lindex $args $i]
            } default {
                lappend passon_args [lindex $args $i]
            }
        }
        # puts "passon_args = $passon_args"
        if ![info exists sensitivevars] { error "sensitive vars must be specified" }
        if ![info exists sensitiveexpr] { set sensitiveexpr "\[set [lindex $sensitivevars 0]\]" }
        if ![info exists menuentry] { set menuentry "" }

        foreach sensitivevar $sensitivevars {
            upvar #0 $sensitivevar sensitive
            set command "after 1 \{ [list sensitive:change $w $sensitiveexpr $menuentry] \} "
            trace variable sensitive w $command
            bind $w <Destroy> "+trace vdelete $sensitivevar w [list $command]"
        }
        if {$menuentry == ""} { 
            set config config 
        } else {
            set config [list entryconfig $menuentry]
        }
        if [uplevel #0 "expr $sensitiveexpr"] {
            if [catch {eval $w.b $config -state normal}] {
                eval $w $config -state normal
            }
        } else { 
            if [catch {eval $w.b $config -state disabled}] {
                eval $w $config -state disabled
            }
        }
        return $w
}


proc sensitive:change { w sensitiveexpr menuentry args } {
    if [catch {
        global errorInfo
        set status [catch {uplevel #0 "expr $sensitiveexpr"} res]
        if $status { puts "warning (sensitive:change) : $res, $errorInfo"; return}
        if {$menuentry == ""} { 
            set config config
        } else {
            set config [list entryconfig $menuentry]
        }
        if $res { set mode normal } else { set mode disabled }
        switch -- [winfo class $w] Frame {
            eval $w.b $config -state $mode
        } default {
            eval  $w $config -state $mode
        }
    } err] { global errorInfo ; puts stderr "warning (sensitiveexpr = $sensitiveexpr) : $errorInfo"; raise $errorInfo }
}    
    
    
