#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------






# Procedure: scrollable
#
# Synopsis:
#       Modify a widget creation command to create a `scrollable' widget.
#
# Usage:
#c      scrollable widgetType pathName ?option value?...
#
# Parameters:
#c      widgetType
#               A widget creation command such as `button' or `listbox'.
#
#c      pathName
#               Name of the frame in which the scrollable widget will be
#               created.
#
# Options:
#       Name:                   horizontal
#       Class:                  Horizontal
#       Command-Line Switch:    -horizontal
#
#       Name:                   vertical
#       Class:                  Vertical
#       Command-Line Switch:    -vertical
#
#       Other options are those accepted by the `widgetType' command.
#
# Description:
#
# Bugs:
#
#       - The scrollable processor does not honor the `configure' widget
#       command.
#
#       - The scrollable processor does not use the widget creation
#       definitions to make itself a first-class widget.

option add *Scrollable.vertical 1 widgetDefault
option add *Scrollable.horizontal 0 widgetDefault
option add *Scrollable.highlightThickness 1 widgetDefault

proc scrollable {type w args} {
        global scrollable_priv

        global gui_flags

        if [winfo exists $w] { error "$w already exists"  }
        frame $w -class Scrollable

        set horizontal [option get $w horizontal Horizontal]
        set vertical [option get $w vertical Vertical]
        set fargs {}

        while {[llength $args] >= 2} {
                set option [lindex $args 0]
                set value [lindex $args 1]
                set args [lrange $args 2 end]
                case $option in {
                        -horizontal { set horizontal $value }
                        -vertical { set vertical $value }
                        default {
                                lappend fargs $option $value
                        }
                }
        }

        if {$vertical} {
            pack \
                [scrollbar $w.vscroll \
                        -highlightthickness 0 \
                        -relief sunken \
                        -command "$w.b yview"] \
                -side $gui_flags(scrollbarSide) -fill y
                lappend fargs -yscroll "$w.vscroll set"
        } 
        if {$horizontal} {
            pack \
                [scrollbar $w.hscroll \
                        -highlightthickness 0 \
                        -relief sunken \
                        -orient horiz -command "$w.b xview"] \
                -side bottom -fill x
                lappend fargs -xscroll "$w.hscroll set"
        }
        set subw [eval [list $type $w.b] $fargs -highlightthickness 0]
        pack $subw -expand yes -fill both
        rename $w [set w]_renamed
        proc $w { args } "return \[eval [list scrollable:command $w] \$args\]"
        bind $w Destroy "+rename [set w]_renamed {}"
        set scrollable_priv($w,type) $type
        return $w
}


proc scrollable:command { w command args } {
        global scrollable_priv
        switch -- $command $scrollable_priv($w,type) {
            if {[llength $args]==0} { 
                return $w.b
            } else {
                eval [list $w.b] $args
            }
        } default {
            eval [list [set w]_renamed $command] $args
        }
}    
