#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





 # X resources

option add *Errormessage.borderWidth 2 21
option add *Errormessage.relief raised 21
option add *Errormessage*Foreground black 21
option add *Errormessage.top.m.Foreground black 21
option add *Errormessage*Background #ffe4c4  21

proc errormessage {w text} {
        global errormessage_priv
        modalDialog transient choicebox $w \
                -text $text \
                -buttons OK \
                -icon error \
                -textvariable errormessage_priv \
                -withfeedback 0
        catch {unset errormessage_priv}
        tkwait variable errormessage_priv
        unset errormessage_priv
        modalDialog.end $w
}

proc information {parent text args} {
        global gui_flags
        if ![winfo exists $parent.info] {
            transient scrollable text $parent.info \
                -decorate 1 \
                -font $gui_flags(font,feedback) \
                -relief sunken \
                -borderwidth 2 \
                -width 60 \
                -height 8 \
                -withfeedback 0
            wm title $parent.info "Information"
        }
        $parent.info.b.b delete 1.0 end
        $parent.info.b.b insert insert $text
        $parent.info.b.b config -state disabled
        pack [button $parent.info.dismiss -text Dismiss -command "destroy $parent.info"]
}

