#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




# for autoloading...
proc composite {} { }

composite_define Composite {
        {-bd borderWidth}
        {-borderwidth borderWidth BorderWidth 0 composite_configLocal}
        {-cursor        cursor  Cursor  {}}
        {-geometry geometry Geometry {} composite_configLocal}
        {-height height Height 0 composite_configLocal}
        {-relief relief Relief flat composite_configLocal}
        {-width width Width 0 composite_configLocal}
} composite_initProc

composite_subcommand Composite configure {w args} {
        set class [winfo class $w]
        upvar #0 config$w config
        upvar #0 ${class}_configResource resource
        upvar #0 ${class}_configResourceClass resourceClass
        upvar #0 ${class}_configDefault configDefault
        upvar #0 ${class}_configSwitch switch
        case [llength $args] in {
                0 {
                        set list {}
                        foreach f [lsort [array names resource]] {
                                set r $resource($f)
                                set item [list $f $r]
                                if {$f == $switch($r)} {
                                        lappend item $resourceClass($r) \
                                                $configDefault($r) \
                                                $config($r)
                                }
                                lappend list $item
                        }
                        return $list
                }
                1 {
                        set s [lindex $args 0]
                        set r [composite:findConfigFlag $w $s]
                        return [list $switch($r) \
                                 $r \
                                 $resourceClass($r) \
                                $configDefault($r) \
                                $config($r)]
                }
                default {
                        eval [list composite:applyConfig $w] $args
                }
        }
}

# Procedure:    composite_initProc
#
# Synopsis:
#       Initialization procedure for widgets that may not be instantiated.
#
# Usage:
#c      composite_initProc pathName
#
# Parameters:
#c      pathName
#               Path name of the widget that is being instantiated
#               erroneously.
#
# Return value:
#       None -- the procedure always throws an error.

proc composite_initProc w {
#       error "can't create a raw [winfo class $w]"
}

