#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc buttonbar {} {}

composite_define ButtonBar {
        {-orient orient Orient horizontal composite_configPrivateNop}
} ButtonBar::initProc

proc ButtonBar::initProc { w  } {
        global gui_flags
        upvar #0 config$w config
        upvar #0 $w data
        set config(relief) sunken
        set config(borderWidth) 2
        switch $config(orient) vertical {
            set data(fill)  y
            set data(side)  top
            set data(other_side)  bottom
        } horizontal {
            set data(fill)  x
            set data(side)  left
            set data(other_side)  right

        }
        pack [button $w.fill \
                -font $gui_flags(font,bbar_buttons) \
                -state disabled] -fill both -expand yes -side $data(other_side)
        return $w
}

#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

composite_subcommand ButtonBar addbutton { w args } {
        global gui_flags
        upvar #0 $w data
        if ![info exists data(count)] {
            set data(count) 0
        }
        set argc [llength $args]
        set i 0
        while {[string index [lindex $args $i] 0]!="-" && $i < $argc} {
           lappend modifiers [lindex $args $i]
           incr i
        }
        set configs [lrange $args $i end]
        # puts "configs = $configs"
        incr data(count)
        set buttonw [eval $modifiers $w.b$data(count) -font $gui_flags(font,bbar_buttons) -relief raised $configs]
        pack $buttonw -side $data(side) -fill x
        return $buttonw
}


