#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





proc TheoryTree { w args} {
        global vals
        global TheoryTree_flags
        global TkTheoryViewer_library
        global gui_flags
        frame $w -class TheoryTree -relief sunken

#       pack [frame $w.controls -relief sunken -borderwidth 2] -side left -fill y
#       pack [button $w.controls.expand1 -bitmap @$TkTheoryViewer_library/src/expand1.xbm -command "hierarchy::expandnoden $w.hier"]
#       pack [button $w.controls.expand3 -bitmap @$TkTheoryViewer_library/src/expand3.xbm -command "hierarchy::expandselection $w.hier"]

        frame $w.box
        pack $w.box -expand yes -fill both -side left

        scrollbar $w.horiz -orient hor -command "$w.hier.canv xview" -relief sunken
        scrollbar $w.vert -orient vert -command "$w.hier.canv yview" -relief sunken

        hierarchy $w.hier \
                -font $TheoryTree_flags(font) \
                -expand 1 \
                -rootnode [ML current_theory()] \
                -rootanchor $TheoryTree_flags(theoryTreeAnchor) \
                -debug 0 \
                -xscrollcommand "$w.horiz set" \
                -yscrollcommand "$w.vert set" \
                -padstack 7 \
                -paddepth 16 \
                -relief sunken \
                -borderwidth 2 \
                -commonselect 1 \
                -nodechildren "TheoryTree::nodechildren $w"\
                -nodelook "TheoryTree::nodelook $w"

        pack $w.horiz -in $w.box -side bottom -fill x
        pack $w.vert -side $gui_flags(scrollbarSide) -fill y
        pack $w.hier -ipady 10 -ipadx 10 -in $w.box -side top -expand yes -fill both
        eval [list TheoryTree::configure $w] $args
        
        
        hierarchy::expandnoden $w.hier [ML "current_theory()"] $TheoryTree_flags(theoryTreeInitialExpand) -prune $TheoryTree_flags(theoriesToPrune)
        bind $w <Destroy> "+TheoryTree::upon_destroy $w %W"     
        trace variable TheoryTree_flags(theoryTreeAnchor) w "TheoryTree::anchor_change_notify $w"
        
}

                                      

proc TheoryTree::nodelook { w node_path showing_kids } {
        global hierarchy_library 
        set theory [lindex $node_path [expr [llength $node_path]-1]]
        set bitmap @$hierarchy_library/src/folder.xbm
        set textFill black
        set bitmapColor black
        return [list $theory $textFill {} $bitmap $bitmapColor] 
}


proc TheoryTree::nodechildren { w node_path } {
        global TheoryTree_flags
        set theory [lindex $node_path [expr [llength $node_path]-1]]
#       puts "In TheoryTree::nodechildren, node_path = $node_path"
        if {[lsearch $TheoryTree_flags(theoriesToFlatten) $theory]==-1} {
            set parents [ML -type stringlist "parents [ml_string $theory]"]
        } else {
            set parents [ML -type stringlist "[hol_ancestors] [ml_string $theory]"]
        }
        # Filter the parents to only show starter-theories if they
        # are the only parent theory, since they are rarely "real" parents.
        #
        # Also check for duplicated parents in the parent list (yes.. this
        # can happen, at least in hol88!)

        if {[llength $parents]!=1} {
                set new_parents ""
                foreach parent $parents {
                    if {[lsearch $TheoryTree_flags(theoriesToIgnore) $parent]==-1 && [lsearch $new_parents $parent]==-1} { 
                        lappend new_parents $parent 
                    }
                }
                set parents $new_parents
        }
#       puts "Leaving TheoryTree::nodechildren, node_path = $node_path, parents = $parents"
        return [lsort $parents]
}

proc TheoryTree::upon_destroy { w realw } {
    if {$realw==$w} {
        unset_vals_for_widget $w
        global TheoryTree_flags
        trace vdelete TheoryTree_flags(theoryTreeAnchor) w "TheoryTree::anchor_change_notify $w"
    }
}

proc TheoryTree::configure { w args} {
        global vals
        set passon_args $args
        if {[llength $passon_args]!=0} {
            eval [list hierarchy::configure $w.hier] $passon_args
        }
}


proc TheoryTree::setselection { w args} {
        eval [list hierarchy::setselection $w.hier] $args
}


proc TheoryTree::anchor_change_notify { w args } {
        global TheoryTree_flags
        hierarchy::configure $w.hier  -rootanchor $TheoryTree_flags(theoryTreeAnchor)
}

#----------------------------------------------------------------------------
#  theory_graph_change_Notify
#
# Called when the logical structure of the theory hierarchy changes.
# We force a redraw of the theory hierarchy to make sure all changes
# are reflected.  Unfortunately this will not maintain the same nodes
# open as before, but it is difficult to fix this.
#
#----------------------------------------------------------------------------



proc TheoryTree::remake_hierarchy { w  } {
        global vals
        global TheoryTree_flags
        set selection [hierarchy::selection $w.hier]
        hierarchy::configure $w.hier \
            -rootnode [ML "current_theory()"] \
           -font $TheoryTree_flags(font)
        hierarchy::expandnoden $w.hier [ML "current_theory()"] $TheoryTree_flags(theoryTreeInitialExpand) -prune $TheoryTree_flags(theoriesToPrune)
        eval [list hierarchy::setselection $w.hier] $selection
}



