#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------






proc TkTRS::ProcessArgs { argc argv } {
        global TkTRS_flags

        if {[llength [info commands Preferences_Add]]==1} {
            Preferences_Add "TkTRS" "Options related to loading and using the TkTRS Theory Retrieval System are specified here." \
                [list \
                    [list TkTRS_flags(loadOnStartup) loadOnStartup BOOL 0 "Load trs library on startup" "If this option is set then the trs library will be loaded upon startup, instead of when it is first used."] \
             ]
        }

}

proc TkTRS::InitialisePackage { } {
        global TkTRS_flags
        global gui_flags
        global install_dir_tkhol

        set TkTRS_flags(loaded) 0
        if [hol90] {
            if [catch {ML -toplevel 1 "
                Globals.library_path := \n(!Globals.library_path)@
                      [ml_stringlist $install_dir_tkhol/hol90/retrieve/];
                find_library [ml_string retrieve]
            "}] {
                errormessage .error \
"The library description file
        $install_dir_tkhol/hol90/retrieve/retrieve.hol_lib 
could not be found.   Perhaps the library has not been
made for hol90.  Consult your installation guide and remake
the library.  If problems persist, contact $gui_flags(maintainer)"
            }
        }
        if $TkTRS_flags(loadOnStartup) {
            TkTRS::delayed_Load
        }
}


proc TkTRS::delayed_Load { } {
        global TkTRS_flags TkTRS_library
        global feedback
        if {!$TkTRS_flags(loaded)} {
            set feedback [list {} "Loading retrieve library, 30-60 seconds..."]
            hol_load_library retrieve
            set TkTRS_flags(loaded) 1
        }
}

