#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc GOAL::code { objspec } {
            return [lindex $objspec 1]
}

proc GOAL::header { objspec } {
            return [lindex $objspec 1]
}

proc GOAL::generate { objspec flagsvar } {
        upvar 1 $flagsvar flags
        global TheoremWidgets_flags
        if {$flags(richtext) || $flags(structuredtext)} {
            return [HolPP::generate [lindex $objspec 1] HolPP.pp_goal GOAL flags]
        } else {
            if ![info exists flags(showTypes)] { set flags(showTypes) $TheoremWidgets_flags(showTypes) }
            if ![info exists flags(numberAssums)] { set flags(numberAssums) $TheoremWidgets_flags(numberAssums) }
            if ![info exists flags(firstAssumOnTop)] { set flags(firstAssumOnTop) $TheoremWidgets_flags(firstAssumOnTop) }
            set text [ML "Plaintext.goal_to_string \{
                        output_width=$flags(width),
                        show_types=[ml_bool $flags(showTypes)],
                        number_assums=[ml_bool $flags(numberAssums)],
                        first_assum_on_top=[ml_bool $flags(firstAssumOnTop)]
                \} ([lindex $objspec 1])"]
            return [list [list $text]]
        }
}

proc GOAL::select_subobject { textw objspec path } {
        return [HolPP::select_subobject GOAL $textw $objspec $path]
}
