(*====================================================================
 *
 * structure HolTermPatterns
 *                                                                    
 * use "hol90_termpaths/src/termpatterns.sig";
 * use "hol90_termpaths/src/termpatterns.sml";
 * open HolTermPatterns;
 *====================================================================*)
   
structure HolTermPatterns: HolTermPatterns_sig =
struct

   open HolTermPaths;
   
   type termpattern = term;
   val termpattern_of_string = string_to_term;;
   fun string_of_termpattern tp = 
	  term_to_string tp
   val termpattern_of_term = I;
   val termpattern_of_term_quote = term_parser;

   fun general_matching_termpattern ([],tm) =
   	let
	   val var = (
	   let 
              val tyop = (#Tyop o dest_type o type_of) tm
	      val firstchar = hd (explode tyop)
	   in
              if (tyop = "bool") 
              then "P"
	      else if (firstchar >= "a") andalso (firstchar <= "z")
	           then firstchar
		   else "x"
           end
	   handle _ => "x")
        in
	   mk_var{Name=var, Ty=type_of tm}
	end
     | general_matching_termpattern (RATOR::path,tm) =
        mk_comb{Rator=general_matching_termpattern (path,rator tm),Rand=mk_var{Name="_",Ty=type_of(rand tm)}}
     | general_matching_termpattern (RAND::path,tm) =
        let val (con,args) = strip_comb tm
	    val (args',rand') = front_n_back args
	    fun keep_if_const tm = 
		if (is_const tm) 
		then tm else mk_var{Name="_",Ty=type_of tm}
	    fun mkvar tm = mk_var{Name="_",Ty=type_of tm}
	    val new_con = keep_if_const con
	    val new_args' = map mkvar args'
	    val new_rand' = general_matching_termpattern (path,rand')
	in
            list_mk_comb(new_con,new_args'@[new_rand'])
	end
     | general_matching_termpattern (BODY::path,tm) =
      mk_abs{Body=general_matching_termpattern (path,body tm),Bvar=mk_var{Name="v",Ty=type_of(bvar tm)}}; 


   fun termpaths_of_pattern tp = 
      if (is_comb tp)
      then (map (curry (op ::) RATOR) (termpaths_of_pattern (rator tp)))@
 	   (map (curry (op ::) RAND) (termpaths_of_pattern (rand tp)))
      else if (is_abs tp)
      then (map (curry (op ::) BODY) (termpaths_of_pattern (body tp)))
      else if (is_var tp)
      then if (#Name (dest_var tp) = "_")
           then []
	   else [[]]
      else [];
      
   val -| = --;
   
   val |- = 1;
   
end;

(*====================================================================
 *
 * Now define "_" as a polymorphic constant.  Hopefully in later versions
 * of hol90 this will not need to be done.
 *
 *====================================================================*)


open HolTermPatterns;

(*
if (draft_mode()) 
then (new_constant{Name="_",Ty=(==`:'a`==)}; ()) handle HOL_ERR _ => ()
else ((if current_theory() = "HOL"
       then new_theory "termpaths"
       else extend_theory "-");
       new_constant{Name="_",Ty=(==`:'a`==)}; 
       close_theory();
       ()) handle HOL_ERR _ => ();

*)
