(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




(*------------------------------------------------------------------------
 * use "hol90_richtext/src/pp_to_tcl.sig";
 * use "hol90_richtext/src/pp_to_tcl.sml";
 *-----------------------------------------------------------------------*)

signature PPToStrings_sig =
sig

   structure PP: PP_sig

   type linechar;     (* = int * int *)
   type ('val,'branch) ppfun;  
   val mk_ppfun : ({depth:int, outer_prec:PrettySupport.precedence} -> PP.parameters -> ('val * 'branch PP.Labels.label) -> 'branch PP.Labels.label PP.PP.LabelPPBoxes.ppbox) -> ('val,'branch) ppfun
   val dest_ppfun : ('val,'branch) ppfun -> ({depth:int, outer_prec:PrettySupport.precedence} -> PP.parameters -> ('val * 'branch PP.Labels.label) -> 'branch PP.Labels.label PP.PP.LabelPPBoxes.ppbox)

   type parameters 
   val mk_parameters : 
        {interface_maps : PP.StringTable.InterfaceMaps.interface_map list, 
         parameters : PP.parameters } -> parameters
   val dest_parameters :
        parameters->
        {interface_maps : PP.StringTable.InterfaceMaps.interface_map list, 
         parameters : PP.parameters }

   val val_to_strings : 
         ('branch -> string) ->
         {ppfun : ('val,'branch) ppfun,initial_kind:PP.Labels.kind} ->
         parameters ->
         int-> 
         'val -> string list list
   val set_default_look : PP.Labels.look -> unit;
   val default_look : unit -> PP.Labels.look;

   val set_whitespace_look : PP.Labels.look -> unit;
   val whitespace_look : unit -> PP.Labels.look;
end;


