(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




structure HolExternals : HolExternals_sig =
struct
   val is_infix = fn name => is_constant name andalso is_infix name
   and is_binder = is_binder
   and is_res_quan = fn name => not (assoc2 name (binder_restrictions()) = NONE);
   
   fun restriction_name name =
      case (assoc2 name (binder_restrictions()))
      of NONE => name
       | SOME (binder,_) => binder;
   
   val pad_binder =
      let val symbols = explode "#?+*/\\=<>&%@!,:;_|~-"
          val symbolic = all (fn c => mem c symbols) o explode
      in  fn s => if (symbolic s) then s else (s ^ " ")
      end;
   
   val fixity = fn s => case (fixity s) of Infix prec => prec | _ => 0;



   (* Flags controlling the output *)
      
   fun replicate (s,0) = ""
     | replicate (s,n) = s ^ replicate (s,n - 1);
   
   fun common_frees ((varstruct,_),(t1,_),(t2,_)) =
      set_eq (strip_pair varstruct) (intersect (free_vars t1) (free_vars t2));
   
   
end;
                
