(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




(*--------------------------------------------------------------------
 * use "hol90_richtext/pp/hol.pp.externals.sig";
 * use "hol90_richtext/pp/hol.pp.externals.sml";
 *--------------------------------------------------------------------*)
structure HolConstructors : HolConstructors_sig = struct end;
structure HolStringTable = PPStringTable;
structure HolLabels = PPLabels;

structure HolDestructors : HolDestructors_sig =
struct

   structure PPLabels = PPLabels;
   structure HolBranches = HolBranches;
   structure HolTermKinds = HolTermKinds;
   open PPLabels;
   open HolTermKinds;
   open HolBranches.HolTermPaths;
   open HolBranches;
   
   (*--------------------------------------------------------------------*)
   (* ABS : term *  label -> (term * label) * (term * label)             *)
   (* COMB : term * label -> (term * label) * (term * label)             *)
   (* CONST : term * label -> string * (hol_type * label)                *)
   (* GOAL : goal * label -> (term * label) list * (term * label)        *)
   (* PABS : term * label -> (term * label) * (term * label)             *)
   (* THM : thm * label -> (term * label) list * (term * label)          *)
   (* TYPE : hol_type * label -> string * (hol_type * label) list        *)
   (* VAR : term * label -> string * (hol_type * label)                  *)
   (* VARTYPE : hol_type * 'a -> string                                  *)
   (*--------------------------------------------------------------------*)

   val BVAR = EXTRACTED_TERM bvar;
   (*--------------------------------------------------------------------*)
   (* Some auxillary functions                                           *)
   (*                                                                    *)
   (*--------------------------------------------------------------------*)
   
   fun zip ([],[]) = []
     | zip (x::xs,y::ys) = (x,y)::(zip (xs,ys))
     | zip _ = raise Fail "zip";
   fun upto from to =
      if (from > to)
      then []
      else from::(upto (from + 1) to);
   
   fun VARTYPE (ty,_) = dest_vartype ty
   
   fun TYPE (ty,label) =
      case dest_type ty
      of {Tyop,Args} => (Tyop,map (fn (arg,i) => (arg,label_aBranch (TYARG i) (label_uKind (SOME "TYPE") label)))
                                  (zip (Args,upto 1 (length Args))));
   
   fun VAR (tm,label) = 
      case dest_var tm of {Name,Ty} => 
        (Name,(Ty,label_aBranch TYPEOF (label_uKind (SOME "TYPE") label)))
   fun CONST (tm,label) = 
      case dest_const tm of {Name,Ty} => 
        (Name,(Ty,label_aBranch TYPEOF (label_uKind (SOME "TYPE") label)))
   fun COMB (tm,label) =
      case dest_comb tm of {Rator,Rand} => 
        ((Rator,label_aBranch (TERM_BRANCH RATOR) (label_uKind (kind_of_term Rator) label)),
         (Rand,label_aBranch (TERM_BRANCH RAND) (label_uKind (kind_of_term Rand) label)))
   fun ABS (tm,label) =
      case dest_abs tm of {Bvar,Body} => 
        ((Bvar,label_aBranch BVAR (label_uKind (kind_of_term Bvar) label)),
         (Body,label_aBranch (TERM_BRANCH BODY) (label_uKind (kind_of_term Body) label)));
   
   fun PABS (tm,label) =
      (case dest_pabs tm
       of {varstruct,body} => 
        ((varstruct,label_aBranch (EXTRACTED_TERM (#varstruct o dest_pabs)) (label_uKind (kind_of_term varstruct) label)),
         (body,label_aBranch (TERM_BRANCH BODY) (label_uKind (kind_of_term body) label))))
      handle _ => ABS (tm,label);
   
   fun THM (th,label) =
      let val (hs,c) = dest_thm th
      in  (map (fn (h,i) => (h,label_aBranch (HYP i) (label_uKind (kind_of_term h) label))) (zip (hs,upto 1 (length hs))),
           (c,label_aBranch CONCL (label_uKind (kind_of_term c) label)))
      end;
   
   fun GOAL (gl:goal,label) =
      let val (hs,c) = gl
      in  (map (fn (h,i) => ((Integer.makestring i,h),label_aBranch (HYP i) (label_uKind (kind_of_term h) label))) (zip (hs,upto 1 (length hs))),
           (c,label_aBranch CONCL (label_uKind (kind_of_term c) label)))
      end;
   
   fun HYPOTH ((s,t),label) = (s,(t,label))
   
end;
   
