(* user.ml                                               (c) R.J.Boulton 1990 *)
(*----------------------------------------------------------------------------*)


signature TRS_user_sig =
sig
	val FT : TRS_matching.thmpattern -> TRS_search.source -> TRS_search.searchstep
	val CS : TRS_search.searchstep -> TRS_search.searchstep
	val run_search : TRS_search.searchstep -> foundthm list
	val full_search : TRS_matching.thmpattern -> TRS_search.source -> foundthm list
	val search_until_find : TRS_search.searchstep -> TRS_search.searchstep
	val search_n_theories : int -> TRS_search.searchstep -> TRS_search.searchstep
	val search_n_until_find : int -> TRS_search.searchstep -> TRS_search.searchstep
	val ancestors_excluding : string list -> string list -> TRS_search.searchpath
	val List_from : TRS_search.searchstep -> TRS_search.source
	val kind : TRS_matching.thmkind -> TRS_matching.thmpattern
	val thryname : string -> TRS_matching.thmpattern
	val thmname : string -> TRS_matching.thmpattern
	val conc : term -> TRS_matching.thmpattern
	val hypP : term list -> TRS_matching.thmpattern
	val hypF : term list -> TRS_matching.thmpattern
	val side : side_condition -> TRS_matching.thmpattern
end;
