(* struct.sig,v 1.1.1.1 1995/04/06 18:44:35 drs1004 Exp                                            (c) R.J.Boulton 1990 *)
(*----------------------------------------------------------------------------*)

signature TRS_struct_sig =
sig

	exception get_ids_FAIL

	val get_ids : term -> (term list * (term list * term list))
	val get_consts : term -> term list
	val get_freevars : term -> term list
	val get_boundvars : term -> term list
	val get_types : term -> Type.hol_type list
	val is_primtype : Type.hol_type -> bool
	val subtypes : Type.hol_type -> Type.hol_type list
	val prim_subtypes : Type.hol_type -> Type.hol_type list
	val get_primtypes : term -> Type.hol_type list
	val get_primvartypes : term -> Type.hol_type list
	
	exception wildvar_FAIL;
	type wildvar;
   	val make_wildvar : Term.term -> wildvar
	val wildvarlist : Term.term list -> wildvar list

	exception wildtype_FAIL;
	type wildtype;
   	val  make_wildtype : Type.hol_type -> wildtype
	val wildtypelist : Type.hol_type list -> wildtype list

	exception termpattern_FAIL;
	type termpattern;
   	val make_termpattern : (Term.term * wildvar list * wildtype list) -> termpattern
	val show_full_termpattern : termpattern -> (Term.term * Term.term list * Type.hol_type list)
	val make_full_termpattern : (Term.term * Term.term list * Type.hol_type list) -> termpattern
	val autotermpattern : Term.term -> termpattern
	
	type matching;
   	val show_matching : matching -> ((wildvar * Term.term) list * (wildtype * Type.hol_type) list)
   	val null_matching : matching
   	val make_matching : termpattern -> Term.term -> matching
	val join_matchings : matching -> matching -> matching
	val show_full_matching : matching -> ((Term.term * Term.term) list * (Type.hol_type * Type.hol_type) list)

	exception UNKNOWN_WILDVAR;
	val match_of_var : matching -> wildvar -> Term.term
	exception UNKNOWN_WILDTYPE;
	val match_of_type : matching -> wildtype -> Type.hol_type
	
	datatype result_of_match = Nomatch
               			| Match of matching * (unit -> result_of_match);

	val Match_null : result_of_match;
	val approms : (unit -> result_of_match) -> (unit -> result_of_match) -> 
                                                (unit -> result_of_match)

	val bool_to_rom : bool -> result_of_match
	val rom_to_bool : result_of_match -> bool

	
end;


