(* search.ml                                             (c) R.J.Boulton 1990 *)
(*----------------------------------------------------------------------------*)


signature TRS_search_sig =
sig
	val get_theorems : string -> foundthm list
	datatype searchpath = Theory of string
                | Ancestors of string list * string list;
	datatype source = List of foundthm list
            	| Paths of searchpath list;
	val do_once_only :  ''a list -> ''a list
	val searchseq : string list -> string list -> string list
	val flatten_paths : searchpath list -> string list
	datatype searchstep = Endofsearch of foundthm list
                   | Step of foundthm list * (unit -> searchstep);
	val find_theorems : TRS_matching.thmpattern -> source -> searchstep
	val show_step : searchstep -> foundthm list
	exception continue_search_ERROR;
	val continue_search : searchstep -> searchstep
end;
