(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




(* 
 * use "/homes/drs1004/projects/tkhol/hol90/replay/src/theory_scripts.sig"; 
 * use "/homes/drs1004/projects/tkhol/hol90/replay/src/theory_scripts.sml"; 
 * use "/homes/drs1004/projects/tkhol/smlpp/src/smlpp.sml";
 * map FileAnalysis.fragment_name (rev (analyse_analysis(open_in f)));
 * el 62 (rev (analyse_analysis(open_in f)));
*)

structure FileAnalysis : FileAnalysis_sig =
struct

structure ScriptFragments = ScriptFragments;
open ScriptFragments;
open System;
open System.Ast;
open System.Compile;
open System.Env;

open System.Unsafe.SysIO;       (* for comparing file access times *)
open System.Timer;

(*-----------------------------------------------------------------
 * Caches analysis
 *-----------------------------------------------------------------*)



val analysis_cache = ref ([]: (string * (analysis * time)) list)

fun delete_cache () = (analysis_cache := []);
fun delete_cache_for_file file = 
    (analysis_cache := (filter (fn (s,_) => (s <> file)) (!analysis_cache)))

fun analysis_for_file file =
   let val reload = 
      let val (_,time) = assoc file (!analysis_cache)
      in (earlier (time,mtime (PATH file)))
      end
      handle _ => true
   in 
      if reload 
      then let val time = System.Unsafe.CInterface.gettimeofday()
               val analysis = analyse_file file
               val _ = (analysis_cache := (file,(analysis,time))::(!analysis_cache))
           in
              analysis
           end
      else #1 (assoc file (!analysis_cache))
   end;


exception FRAGMENTS_FOR_FILE
fun fragments_for_file file = 
   case analysis_for_file file of
      FRAGMENTS f => f
    | ERRORS _ => raise FRAGMENTS_FOR_FILE

exception ERRORS_FOR_FILE
fun errors_for_file file = 
   case analysis_for_file file of
      FRAGMENTS _ => raise ERRORS_FOR_FILE
    | ERRORS e => e

fun file_analyses_ok file = 
   case analysis_for_file file of
      FRAGMENTS _ => true
    | ERRORS e => false




(*-----------------------------------------------------------------
 * HOL specifics
 *-----------------------------------------------------------------*)

val files_for_theory_cache = ref ([]: (string * string list) list)

fun files_for_theory theory =
   assoc theory (!files_for_theory_cache)
   handle _ =>
   let val bases = 
           case theory of 
              "TRANSC" => ["transc.sml"]
            | "HRAT" => ["hrat.sml"]
            | "HREAL" => ["hreal.sml"]
            | "LIM" => ["lim.sml"]
            | "NETS" => ["nets.sml"]
            | "POWSER" => ["powser.sml"]
            | "REAL" => ["real.sml"]
            | "REALAX" => ["realax.sml"]
            | "SEQ" => ["seq.sml"]
            | "TOPOLOGY" => ["topology.sml"]
            | "list" => ["mk_list.sml","mk_list_thms.sml"]
            | _ => ["mk_" ^ theory ^ ".sml"]
       fun lookin path =
         let val _ = first (fn x => access(path ^ x,[])) bases
         in map (fn x => path ^ x) bases
         end
       val res = lookin (pwd() ^ "/")
         handle _ =>
         tryfind lookin (map (fn p => p ^ "../src/") (!Globals.theory_path))
       val _ = (files_for_theory_cache := (theory,res)::(!files_for_theory_cache))
   in
      res
   end;


fun delete_cache_for_theory th = 
        (map delete_cache_for_file (files_for_theory th); ())

end;

