structure replay_lib  = 
struct

val replay_lib = 
   Library.new_library
         {name = "replay",
          doc = "HOL ML-Pretty Pretty Printer for the Base HOL Logic, by Richard Boulton and Donald Syme",
          path = replay_lib_path,
          parents = [find_library "pp_to_tcl", find_library "smlpp", find_library "proofs"],
          theories = [],
          code = [
		"../pp/proofs.pp.support.sig",
		"../pp/proofs.pp.support.sml",
		"../pp/proofs.pp.sml",
		"../pp/proofs.pp.totcl.sml",
		"script_fragments.sig",
		"script_fragments.sml",
		"theory_scripts.sig",
		"theory_scripts.sml"
	  ],
          help = [(replay_lib_path ^ "help/entries/"), (replay_lib_path ^ "help/internals/")],
          loaded = "fn () => ()"};
end;
