(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




signature ProofsBranches_sig = sig
   type branch sharing type branch = string
   val string_of_branch : string -> string
end

signature ProofsDestructors_sig = sig
   structure ProofsBranches : ProofsBranches_sig
   structure PPLabels : PPLabels_sig
   structure BwdProofs : BwdProofs_sig
   structure PartialBwdProofs : PartialBwdProofs_sig
   val TAC : (string * ProofsBranches.branch PPLabels.label) -> string
   val BWDTAC : (BwdProofs.bwdop * ProofsBranches.branch PPLabels.label) -> 
                (string * ProofsBranches.branch PPLabels.label)
   val BWDTHENL : (BwdProofs.bwdop * ProofsBranches.branch PPLabels.label) -> 
                  (BwdProofs.bwdproof * ProofsBranches.branch PPLabels.label) list
   val SINGLE_BWDTHENL : (BwdProofs.bwdop * ProofsBranches.branch PPLabels.label) -> 
                  (BwdProofs.bwdproof * ProofsBranches.branch PPLabels.label) 
   val BWDPROOF : (BwdProofs.bwdproof * ProofsBranches.branch PPLabels.label) -> 
                  (BwdProofs.bwdop * ProofsBranches.branch PPLabels.label) list

   val PBWDTAC : (PartialBwdProofs.pbwdop * ProofsBranches.branch PPLabels.label) -> 
                (string * ProofsBranches.branch PPLabels.label)
   val PBWDTHENL : (PartialBwdProofs.pbwdop * ProofsBranches.branch PPLabels.label) -> 
                   (PartialBwdProofs.pbwdproof * ProofsBranches.branch PPLabels.label) list
   val SINGLE_PBWDTHENL : (PartialBwdProofs.pbwdop * ProofsBranches.branch PPLabels.label) -> 
                   (PartialBwdProofs.pbwdproof * ProofsBranches.branch PPLabels.label)
   val PBWDPROOF : (PartialBwdProofs.pbwdproof * ProofsBranches.branch PPLabels.label) -> 
                  (PartialBwdProofs.pbwdop * ProofsBranches.branch PPLabels.label) list
end

