

#----------------------------------------------------------------------------
# TkZ::ProcessArgs
#
# 	-norichtext 	turn rich text output off.  Automatically off
#			for hol90.
#
#----------------------------------------------------------------------------

proc TkZ::ProcessArgs { argc argv } {
	global TkZ_flags
	set TkZ_flags(richtext) 1

   if {[llength [info commands Preferences_Add]]==1} {
    Preferences_Add "Z Fonts and Colours" \
"Preferences related to HOL Z support may be \
specified here.  " [list \
        [list TkZ_flags(interface_map,TkZ) TkZ INTERFACE_MAP [list \
    	    [list [list PABS COMB CONST] 	DELTA 		[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* D 	D]]] \
    	    [list [list PABS COMB CONST] 	XI 		[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* X 	X]]] \
    	    [list [list PABS COMB CONST] 	THETA 		[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* q	q]]] \
    	    [list [list PABS COMB CONST] 	BIGNOT 		[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* ~	~]]] \
    	    [list [list PABS COMB CONST] 	{|/\\|} 	[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* {\217}	"\x0d9"]]] \
	    [list [list PABS COMB CONST] 	{|\\/|} 	[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* {\218}	"\x0da"]]] \
	    [list [list PABS COMB CONST] 	|==>| 		[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* {\222}	"\x0de"]]] \
	    [list [list PABS COMB CONST] 	|<==| 		[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* {\220}	"\x0dc"]]] \
	    [list [list PABS COMB CONST] 	PSET 		[list [list Roman-Bold-R-Normal-Large|*-*-*-*-Black-*-*-*-* P 	P]]] \
	    [list [list PABS COMB CONST] 	>< 		[list [list Symbol-Medium-R-Normal-Large|*-*-*-*-Black-*-*-*-* 	{\180}	"\x0b4"]]] \
	    [list [list PABS COMB CONST] 	<-> 		[list [list Symbol-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-* 	{\171}	"\x0ab"]]] \
	    [list [list PABS COMB CONST] 	|-> 		[list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-*-* 	{\124\174} "\x07c\x0ae"]]] \
	    [list [list PABS COMB CONST] 	-+> 		[list [list Symbol-Medium-R-Normal-tiny|*-*-*-*-Black-*-*-*-* 	{\190+\174} "\x0be+\x0ae"]]] \
	    [list [list PABS COMB CONST] 	Ap 		[list [list Symbol-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-* 	{\173}	"\x0ad"]]] \
	    [list [list PABS COMB CONST] 	ZAPPLY 		[list [list Symbol-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-* 	{\173}	"\x0ad"]]] \
	    [list [list PABS COMB CONST] 	REL_OVERRIDE 	[list [list Symbol-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-* 	{\197}	"\x0c5"]]] \
	    [list [list PABS COMB CONST] 	--> 		[list [list Symbol-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-* 	{\174}	"\x0ae"]]] \
	    [list [list PABS COMB CONST] 	=/= 		[list [list Symbol-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-* 	{\185}	"\x0b9"]]] \
	    [list [list PABS COMB CONST] 	NOT_IN 		[list [list Symbol-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-* 	{\207}	"\x0cf"]]] \
	    [list [list PABS COMB CONST] 	NN 		[list [list Roman-Bold-R-Normal-Large|*-*-*-*-Black-*-*-*-* N N]]] \
	    [list [list PABS COMB CONST] 	SUBSCRIPT1 	[list [list Roman-Bold-R-Normal-tiny|*-*-*-*-Black-*-*-2-* 1 1]]] \
	] \
        "TkZ Interface Map" \
"The interface map used for producing nifty looking symbols in Tk \
for Z constructs.\n \
Changing these values will \
only take effect if you save the options and restart TkHolWorkbench, \
or if you call the Tcl procedure
	HolRichText::installInterfaceMap TkZ
from a Tcl window (see the \"Packages\" menu)."]
        ]
    }

}


proc TkZ::InitialisePackage { } {
	global TkZ_flags
	RichText::installInterfaceMap TkZ $TkZ_flags(interface_map,TkZ)
}



















