#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




#----------------------------------------------------------------------------
# RichText::ProcessArgs
#
#       -norichtext     turn rich text output off.
#----------------------------------------------------------------------------

proc RichText::ProcessArgs { argc argv } {
        global RichText_flags
        global gui_flags
        set RichText_flags(richtext) 1

   if {[llength [info commands Preferences_Add]]==1} {
    Preferences_Add "RichText Fonts" \
"Fonts and font sizes for all objects printed via RichText can be \
specified here.  A better way for specifying fonts will be \
developed real soon now." [list \
        [list RichText_flags(richtextOnByDefault) richText BOOL 1 "Use Rich Text by Default" \
"Whether $gui_flags(title) should use rich text \
by default when a display window is \
created.   Structured text allows sub-terms and types to be selected \
and pasted, but is slower than non-structured (teletype) text. \
"] \
        [list RichText_flags(structuredtextOnByDefault) structuredText BOOL 1 "Use Structured Text by Default" \
"Whether $gui_flags(title) should use structured text \
by default when a display window is \
created.   Structured text allows sub-terms and types to be selected \
and pasted, but is slower than non-structured (teletype) text. \
"] \
        [list RichText_flags(default_look) defaultLook LOOK Teletype-Medium-R-Normal-Normal|*-*-*-*-Black-*-*-*-* "Teletype Look" "The look for teletype text"] \
        [list RichText_flags(families,Roman) richTextFontRoman STRING \
                "-Adobe-New Century Schoolbook" "Roman Font Foundry/Family" ""] \
        [list RichText_flags(families,Symbol) richTextFontSymbol STRING \
                "-Adobe-Symbol" "Symbol Font Foundry/Family" ""] \
        [list RichText_flags(families,Helvetica) richTextFontHelvetica STRING \
                "-Adobe-Helvetica" "Helvetica Font Foundry/Family" ""] \
        [list RichText_flags(families,Teletype) richTextFontTeletype STRING \
                "-Adobe-Courier" "Teletype Font Foundry/Family" ""] \
        [list RichText_flags(pointsizes,HUGE) pointSizeHUGE STRING 360 "HUGE Point Size" ""] \
        [list RichText_flags(pointsizes,Huge) pointSizeHuge STRING 240 "Huge Point Size" ""] \
        [list RichText_flags(pointsizes,LARGE) pointSizeLARGE STRING 180 "LARGE Point Size" ""] \
        [list RichText_flags(pointsizes,Large) pointSizeLarge STRING 140 "Large Point Size" ""] \
        [list RichText_flags(pointsizes,Normal) pointSizeNormal STRING 120 "Normal Point Size" ""] \
        [list RichText_flags(pointsizes,small) pointSizesmall STRING 100 "small Point Size" ""] \
        [list RichText_flags(pointsizes,tiny) pointSizetiny STRING 80 "tiny Point Size" ""] \
        ]

   }
        for {set arg 0} {$arg < $argc} {incr arg} {
            if {[lindex $argv $arg]=="-norichtext"} {
                set RichText_flags(richtext) 0
            }
        }
}

proc RichText::installInterfaceMap { name imap } {
            set interface_mappings ""
            set defaults ""
            foreach maplet $imap {
                set kinds [lindex $maplet 0]
                set fromtext [lindex $maplet 1]
                set to_pieces [lindex $maplet 2]
                # puts "maplet = $maplet"
                foreach kind $kinds {
                    if {$fromtext == ""} {
                       if {$kind == "default"} {
                            set default [ml_string $to_pieces]
                       } else {
                            lappend defaults "\n([ml_string $kind],[ml_string $to_pieces])"
                       } 
                    } else {
                       set pieces ""
                       foreach to_piece $to_pieces {
                           lappend pieces "\n([ml_string [lindex $to_piece 0]],[ml_string [lindex $to_piece 1]])"
                       }
                       lappend interface_mappings "\n(([ml_string $kind],[ml_string $fromtext]),[ml_list $pieces])"
                    }
                }

            }
            ML -toplevel 1 "val [set name]_interface_map = InterfaceMaps.Regular.new()"
            ML -type any "(#add_mappings [set name]_interface_map) [ml_list $interface_mappings]"
            ML -type any "(#add_default_looks [set name]_interface_map) [ml_list $defaults]"
            if [info exists default] {
                ML -type any "(#set_default_look [set name]_interface_map) $default"
            }
            ML -type any "InterfaceMapsRegistry.register_interface_map ([ml_string $name], InterfaceMaps.Regular.restrict [set name]_interface_map)"
}



