(*====================================================================
 *
 * HolTermPathTactics
 *
 * val lookup_termpath
 *
 * val PATH_CONV
 *	Apply the conversion at the given location in the term.
 *
 * val PATH_CONV_TAC
 *	Apply the conversion at the given location in the goal.
 *
 * use "../tkhol/hol90_termpaths/src/termpath_tactics.sig";
 * use "../tkhol/hol90_termpaths/src/termpath_tactics.sml";
 *====================================================================*)
 
signature HolTermPathTactics_sig =
sig
   	
   exception PATH_MISMATCH;
   val conv_for_branch : HolTermPaths.termbranch -> conv -> conv;

   val PATH_CONV : HolTermPaths.termpath -> conv -> conv;

   val PATH_CONV_TAC : HolTermPaths.termpath -> conv -> tactic;
   val PATH_REWRITE_TAC : HolTermPaths.termpath -> thm list -> tactic;
   val PATH_ASM_REWRITE_TAC : HolTermPaths.termpath -> thm list -> tactic;
   val ONCE_PATH_REWRITE_TAC : HolTermPaths.termpath -> thm list -> tactic;
   val ONCE_PATH_ASM_REWRITE_TAC : HolTermPaths.termpath -> thm list -> tactic;
   val PURE_PATH_REWRITE_TAC : HolTermPaths.termpath -> thm list -> tactic;
   val PURE_ONCE_PATH_REWRITE_TAC : HolTermPaths.termpath -> thm list -> tactic;
   val PURE_PATH_ASM_REWRITE_TAC : HolTermPaths.termpath -> thm list -> tactic;
   val PURE_ONCE_PATH_ASM_REWRITE_TAC : HolTermPaths.termpath -> thm list -> tactic;
   
end;
























