(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




(*--------------------------------------------------------------       *)
(* theory_notify.nw,v 1.2 1995/11/05 18:27:22 drs1004 Exp       *)
(*                                                                     *)
(*--------------------------------------------------------------       *)
structure TheoryNotification :  TheoryNotification_sig = 
struct
        open Rsyntax;
        type client =
                string *                                (* the theory being watched *)
                (string -> string -> thm -> unit) *     (* called when a new theorem is added to theory *)
                (string -> string -> thm -> unit) *     (* called when a new definition is added to theory *)
                (string -> string -> thm -> unit) *     (* called when a new axiom is added to theory *)
                (string -> term -> unit) *              (* called when a new constant is added to theory *)
                (string -> {Arity:int, Name:string} -> unit);           (* called when a new type added to theory *)

        fun mk_client (x:client) = x;
                
        val notification_list = ref []: ((string * client) list) ref; 
        fun clients () = (!notification_list);

        fun add_client theory client =
                (notification_list := 
                        (append [(theory,client)] (! notification_list));
                ());

        fun remove_client theory clientname =
                (notification_list := 
                    filter ( fn (th,(cl,_,_,_,_,_)) => not(th = theory andalso cl = clientname)) (! notification_list);
                ());

        fun relevant_client_functions theory selector =
                map selector (filter ( fn client => fst(client) = theory) (! notification_list));


        fun most_general_wrapper operation arg =
            let val constants_before = constants "-"
                and types_before = types "-"
                and theorems_before = theorems "-"
                and definitions_before = definitions "-"
                and axioms_before = axioms "-" 
                val res = operation arg in
                (
                        map (fn new_theorem => map (fn f => f (current_theory()) (fst new_theorem) (snd new_theorem))
                              (relevant_client_functions (current_theory()) (fn (_,(_,x,_,_,_,_)) => x))
                            ) (subtract (theorems "-") theorems_before)
                      ; map (fn new_definition => map (fn f => f (current_theory()) (fst new_definition) (snd new_definition))
                              (relevant_client_functions (current_theory()) (fn (_,(_,_,x,_,_,_)) => x))   
                            ) (subtract (definitions "-") definitions_before)
                      ; map (fn new_axiom => map (fn f => f (current_theory()) (fst new_axiom) (snd new_axiom))
                              (relevant_client_functions (current_theory()) (fn (_,(_,_,_,x,_,_)) => x))   
                            ) (subtract (axioms "-") axioms_before)
                      ; map (fn new_constant => map (fn f => f (current_theory()) new_constant)
                              (relevant_client_functions (current_theory()) (fn (_,(_,_,_,_,x,_)) => x))   
                            ) (subtract (constants "-") constants_before)
                      ; map (fn new_type => map (fn f => f (current_theory()) new_type)
                              (relevant_client_functions (current_theory()) (fn (_,(_,_,_,_,_,x)) => x))
                            ) (subtract (types "-") types_before)
                      ; res
                )
            end;;

        
        val save_thm = most_general_wrapper Theory.save_thm;
        val store_thm = most_general_wrapper Tactical.store_thm;
        val new_specification = most_general_wrapper Const_spec.new_specification;
        val new_definition = most_general_wrapper Const_def.new_definition;
        val new_infix_definition = most_general_wrapper Const_def.new_infix_definition;
        val new_recursive_definition = most_general_wrapper Prim_rec.new_recursive_definition;
        val define_type = most_general_wrapper Define_type.define_type;
                                
        fun test () = 
            let exception NEW_THEOREM
                exception NEW_DEFINITION
                exception NEW_AXIOM 
                exception NEW_CONSTANT 
                exception NEW_TYPE in (
                add_client "test4" (mk_client(
                        "client1", 
                        (fn x => raise NEW_THEOREM),
                        (fn x => raise NEW_DEFINITION),
                        (fn x => raise NEW_AXIOM),
                        (fn x => raise NEW_CONSTANT),
                        (fn x => raise NEW_TYPE)
                ));
                (Theory.new_theory "test4"; true)
                andalso ((save_thm("TRUTH",TRUTH); false) handle NEW_THEOREM => true)
           ) end;

end;

open TheoryNotification;


