(*============================================================================*)
(* Definition to support schemas =>                                           *)
(*============================================================================*)

new_theory "BirthdayBook";

(*--------------------------------------------------------------------------*)
(* Load Z library  						    	    *)
(*--------------------------------------------------------------------------*)

prim_load_library Lib.interpret {lib=find_library "Z",theory="-"};
open Z;

(*--------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*)

new_constant {Name="NAME",Ty=(==`:num->bool`==)};
new_constant {Name="DATE",Ty=(==`:num->bool`==)};

(*--------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*)

local 
open Psyntax
in
fun new_schema_definition (name,schema) =
  let val res = new_definition(name,mk_eq(mk_var(name,type_of schema),schema))
      val _ = Z.register_defined_schema{name=name,theory="-"}
  in res
  end

end;

(*--------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*)

val BirthdayBook5 = new_schema_definition("BirthdayBook5", 
(-<`SCHEMA 
   [known IN (PSET NAME);
    birthday IN (NAME -+> DATE)]
   (*---------------------------*)
   [known = dom birthday]`>-)
);

(*--------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*)

val AddBirthday5 = new_schema_definition("AddBirthday5", 
(-<`SCHEMA
   [DELTA BirthdayBook5;
    nameI IN NAME;
    dateI IN DATE]
   (*--------------------------------------------*)
   [~(nameI IN known);
    birthday' = birthday UNION {nameI |-> dateI}]`>-)
);

(*--------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*)

val FindBirthday5 = new_schema_definition("FindBirthday5", 
(-<`SCHEMA
   [XI BirthdayBook5;
    nameI IN NAME;
    dateO IN DATE]
   (*-----------------------*)
   [nameI IN known;
    dateO = (birthday nameI)]`>-)
);

(*--------------------------------------------------------------------------
 *
 *--------------------------------------------------------------------------*)

close_theory();
export_theory();

