#---------------------------------------------------------------
#
#
# setup.tcl - Main script for installation control program.
#
# Author: Donald Syme, Based on code originally found in exmh
# by Brent Welch.
#
# This file and "install.tcl" provide a configurable software
# installation utility.  Most of the work is done in install.tcl -
# this just acts as a command line parser.
#
# Information about the installation parameters can be specified in
# files, e.g. "tkhol.params" and "tksml.params".  These are really
# a set of calls to functions in insall.tcl.
#---------------------------------------------------------------

set applychanges 0
set paramfiles ""
set paramdir "."
set productname "???"
for {set i 0} {$i<[llength $argv]} {incr i} {
    case [lindex $argv $i] -applychanges {
	set applychanges 1
    } -productname {
        incr i
	set productname [lindex $argv $i]
    } -configfile {
        incr i
	set configfile [lindex $argv $i]
    } -paramdir {
        incr i
	set paramdir [lindex $argv $i]
    } -paramfile {
        incr i
	lappend paramfiles [list $paramdir [lindex $argv $i]]
    } default {
	puts stderr "Unrecognized argument [lindex $argv $i]"
    }
}

if ![info exists configfile] {
	puts stderr "-configfile argument required"
	exit 1
}

if [catch {source $configfile}] {
	puts stderr "You should run ./configure before running setup."
	exit 1
}

set topdir .

source $topdir/tksetup/install.tcl
source $topdir/version.tcl
source $topdir/patchlevel.tcl

# Define app name and install save file
install_init $productname $configfile $configfile.sh

# install_version	1 version 		VERSION 	$version {tksml Version number}
install_var	1 gui_flags(maintainer) 	MAINTAINER 	Donald.Syme@cl.cam.ac.uk {Target of error mailings}

foreach paramfile $paramfiles {
   set paramdir [lindex $paramfile 0]
   source $paramdir/[lindex $paramfile 1]
}

# Define test command

# Reread these to ignore the settings in .tksmlinstall
source $topdir/version.tcl
source $topdir/patchlevel.tcl

# Go for it, either applying the changes directly or running the dialog.
if {$applychanges} {
	wm withdraw .
	install_dialog
	installSave
	installSed
	exit
} else {
	install_dialog
}
