(%--------------------------------------------------------------------------%)
(%                  Copyright (c) Donald Syme 1992                          %)
(%                  All rights reserved                                     %)
(%                                                                          %)
(% Donald Syme, hereafter referred to as `the Author', retains the copyright%)
(% and all other legal rights to the Software contained in this file,       %)
(% hereafter referred to as `the Software'.                                 %)
(%                                                                          %)
(% The Software is made available free of charge on an `as is' basis. No    %)
(% guarantee, either express or implied, of maintenance, reliability,       %)
(% merchantability or suitability for any purpose is made by the Author.    %)
(%                                                                          %)
(% The user is granted the right to make personal or internal use of the    %)
(% Software provided that both:                                             %)
(% 1. The Software is not used for commercial gain.                         %)
(% 2. The user shall not hold the Author liable for any consequences        %)
(%    arising from use of the Software.                                     %)
(%                                                                          %)
(% The user is granted the right to further distribute the Software         %)
(% provided that both:                                                      %)
(% 1. The Software and this statement of rights are not modified.           %)
(% 2. The Software does not form part or the whole of a system distributed  %)
(%    for commercial gain.                                                  %)
(%                                                                          %)
(% The user is granted the right to modify the Software for personal or     %)
(% internal use provided that all of the following conditions are observed: %)
(% 1. The user does not distribute the modified software.                   %)
(% 2. The modified software is not used for commercial gain.                %)
(% 3. The Author retains all rights to the modified software.               %)
(%                                                                          %)
(% Anyone seeking a licence to use this software for commercial purposes is %)
(% invited to contact the Author.                                           %)
(%--------------------------------------------------------------------------%)




%<--------------------------------------------------------------       >%
%< Watching the internals of a theory                                  >%
%<--------------------------------------------------------------       >%

lettype theory_client =
                string #                                %< the theory being watched >%
                (string -> string -> thm -> void) #     %< called when a new theorem is added to theory >%
                (string -> string -> thm -> void) #     %< called when a new definition is added to theory >%
                (string -> string -> thm -> void) #     %< called when a new axiom is added to theory >%
                (string -> term -> void) #              %< called when a new constant is added to theory >%
                (string -> (int # string) -> void);;    %< called when a new type is added to theory >%
                
letref theory_notification_list = []: (string # theory_client) list;; 

letrec theory_add_client theory client =
        (theory_notification_list := 
                (append [(theory,client)] (theory_notification_list));
        ());;

letrec theory_remove_client theory clientname =
        (theory_notification_list := 
            filter (\(th,(cl,_,_,_,_,_)). not(th = theory & cl = clientname)) (theory_notification_list);
        ());;

letrec relevant_client_functions theory selector =
        map selector (filter (\client. fst(client) = theory) (theory_notification_list));;

let most_general_theory_wrapper op =
        let constants_before = constants `-`
        and types_before = types `-`
        and theorems_before = theorems `-`
        and definitions_before = definitions `-`
        and axioms_before = axioms `-` in
        (\res. 
                map (\new_theorem. map (\f. f (current_theory()) (fst new_theorem) (snd new_theorem))
                      (relevant_client_functions (current_theory()) (\(_,(_,x,_,_,_,_)). x))   
                    ) (subtract (theorems `-`) theorems_before)
              ; map (\new_definition. map (\f. f (current_theory()) (fst new_definition) (snd new_definition))
                      (relevant_client_functions (current_theory()) (\(_,(_,_,x,_,_,_)). x))   
                    ) (subtract (definitions `-`) definitions_before)
              ; map (\new_axiom. map (\f. f (current_theory()) (fst new_axiom) (snd new_axiom))
                      (relevant_client_functions (current_theory()) (\(_,(_,_,_,x,_,_)). x))   
                    ) (subtract (axioms `-`) axioms_before)
              ; map (\new_constant. map (\f. f (current_theory()) new_constant)
                      (relevant_client_functions (current_theory()) (\(_,(_,_,_,_,x,_)). x))   
                    ) (subtract (constants `-`) constants_before)
              ; map (\new_type. map (\f. f (current_theory()) new_type)
                      (relevant_client_functions (current_theory()) (\(_,(_,_,_,_,_,x)). x))
                    ) (subtract (types `-`) types_before)
              ; res)
        (op ());;

%<--------------------------------------------------------------       >%
%< Now the actual replacement interface which generates notify         >%
%< calls.                                                              >%
%<                                                                     >%
%<--------------------------------------------------------------       >%

letrec save_thm_and_notify (name,thm) =
        (\thm. (map (\f. f (current_theory()) name thm) 
                (relevant_client_functions (current_theory()) (\(_,(_,x,_,_,_)). x)))
              ; thm)
        (save_thm_safe(name,thm));;

letrec new_axiom_and_notify (name,term) =                                                       
                (\thm. (map (\f. f (current_theory()) name thm)                                 
                        (relevant_client_functions (current_theory()) (\(_,(_,x,_,_,_)). x)))   
              ; thm)                                                                            
                (new_axiom(name,term));;                                                        

letrec new_specification_and_notify name specs given_thm =
        most_general_theory_wrapper (\(). new_specification_safe name specs given_thm);;
                        
letrec new_definition_and_notify (name,term) =
        most_general_theory_wrapper (\(). new_definition_safe (name,term));;
                        
letrec new_infix_definition_and_notify (name,term) =
        most_general_theory_wrapper (\(). new_infix_definition_safe (name,term));;
                        
letrec define_type_and_notify name spec =
        most_general_theory_wrapper (\(). define_type_safe name spec);;


let save_thm = save_thm_and_notify;;
let new_axiom = new_axiom_and_notify;; 
let new_specification = new_specification_and_notify;;
let new_definition = new_definition_and_notify;;
let new_infix_definition = new_infix_definition_and_notify;;
let define_type = define_type_and_notify;;


