#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------





option add *TheoremsTopLevel.withtext 0 widgetDefault
option add *TheoremsTopLevel.header "Theorems:" widgetDefault
option add *TheoremsTopLevel.text "" widgetDefault

proc TheoremsTopLevel { w args } {
        global gui_flags 

        set passon_args ""
        for {set i 0} {$i<[llength $args]} {incr i} {
            case [lindex $args $i] -objspecs {
                incr i
                set objspecs [lindex $args $i]
            } -withtext {
                incr i
                set withtext [lindex $args $i]
            } -text {
                incr i
                set text [lindex $args $i]
            } -header {
                incr i
                set header [lindex $args $i]
            } default {
                lappend passon_args [lindex $args $i]
                incr i
                lappend passon_args [lindex $args $i]
            }
        }
        
        # 1. Make the window, lookup its options.
        
        toplevel $w -class TheoremsTopLevel      
        wm withdraw $w
        
        if ![info exists withtext] { set withtext [option get $w withtext WithText] }
        if ![info exists header] { set header [option get $w header Header] }
        if ![info exists text] { set text [option get $w text Text] }

        #
        # 2. Make the internals.
        #
        
        set height [expr {[llength $objspecs] + 2}]
        if {$height < 5} { set height 5 }
        if {$height > 12} { set height 12 }
        
        if {$header!=""} {
            pack [label $w.header \
                    -text $header \
                    -font $gui_flags(font,labels) \
                    -anchor w] \
                -side top -pady 5 -padx 5 -fill x
        }
        
        eval [list richtextobjects $w.objs] $passon_args
        $w.objs richtext text configure \
                -height $height \
                -width 70
        $w.objs listbox configure \
                -geometry 12x$height
        $w.objs richtext configure \
                -richtextvar vals($w,richtext)

        pack $w.objs -expand yes  -fill both -padx 5

        if $withtext {
            set height [llength [split $text \n]]
            if {$height > 12} { set height 12 }
            if {$height < 5} { set height 5 }
            pack [fontcheck scrollable text $w.text \
                    -font $gui_flags(font,codeentry) \
                    -borderwidth 2 \
                    -relief sunken \
                    -height $height] \
                -side top \
                -expand yes \
                -fill both -padx 10 -pady 10
            $w.text.b insert 1.0 $text
        }

        pack [frame $w.controls] -pady 5
        pack [fontcheck focusable button $w.controls.close \
                -command "destroy $w" \
                -text "Close" \
                -width 5 \
                -font $gui_flags(font,buttons)]

        update
        wm deiconify $w
        tkwait visibility $w
        update
        eval [list $w.objs setobjects] $objspecs
        bind $w <Destroy> "unset_vals_for_widget $w"
        
        return $w
        
}






















