#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




proc selectlistbox { w args } {
        set passon_args ""
        set multiselect 0
        for {set i 0} {$i < [llength $args]} {incr i} {
            global gui_flags
            set arg [lindex $args $i]
            switch -- $arg -selectionvar {
               incr i
               set selectionvar [lindex $args $i]
            } -multiselect {
               incr i
               set multiselect [lindex $args $i]
            } default {
               lappend passon_args $arg
               incr i
               lappend passon_args [lindex $args $i]
            }
        }
        eval listbox $w $passon_args
        if {!$multiselect} {
            tk_listboxSingleSelect $w
        }
        if [info exists selectionvar] {
            bind $w <Any-ButtonRelease-1> "set? $selectionvar \[$w curselection\]"
            upvar #0 $selectionvar selection
            if ![info exists selection] { 
                if {$multiselect} {
                    set? selection ""
                } else {
                    set? selection 0
                }
            }
        }
        return $w
}

