#--------------------------------------------------------------------------
#                  Copyright (c) Donald Syme 1992                          
#                  All rights reserved                                     
#                                                                          
# Donald Syme, hereafter referred to as `the Author', retains the copyright
# and all other legal rights to the Software contained in this file,       
# hereafter referred to as `the Software'.                                 
#                                                                          
# The Software is made available free of charge on an `as is' basis. No    
# guarantee, either express or implied, of maintenance, reliability,       
# merchantability or suitability for any purpose is made by the Author.    
#                                                                          
# The user is granted the right to make personal or internal use of the    
# Software provided that both:                                             
# 1. The Software is not used for commercial gain.                         
# 2. The user shall not hold the Author liable for any consequences        
#    arising from use of the Software.                                     
#                                                                          
# The user is granted the right to further distribute the Software         
# provided that both:                                                      
# 1. The Software and this statement of rights are not modified.           
# 2. The Software does not form part or the whole of a system distributed  
#    for commercial gain.                                                  
#                                                                          
# The user is granted the right to modify the Software for personal or     
# internal use provided that all of the following conditions are observed: 
# 1. The user does not distribute the modified software.                   
# 2. The modified software is not used for commercial gain.                
# 3. The Author retains all rights to the modified software.               
#                                                                          
# Anyone seeking a licence to use this software for commercial purposes is 
# invited to contact the Author.                                           
#--------------------------------------------------------------------------




# for autoloading...
proc richtextobjects {} {}

composite_define RichTextObjects {
        {-multiselect multiSelect MultiSelect 1 composite_configPrivateNop}
        {-mlbindbuttons mlbindButtons Buttons 1 composite_configPrivateNop}
        {-command command Command "" composite_configPrivateNop}
        {-expandbuttons expandButtons Buttons 1 composite_configPrivateNop}
        {-optionbuttons optionButtons Buttons 1 composite_configPrivateNop}
        {-exportselection exportSelection ExportSelection 1 composite_configPrivateNop}
        {-selectionvar selectionVar SelectionVar selection composite_configPrivateNop}
        {-showlistbox showListbox ShowListbox 1 composite_configPrivateNop}
        {-showcontrols showControls ShowControls 1 composite_configPrivateNop}
        {-selectioncommand selectionCommand Command nop composite_configPrivateNop}
} RichTextObjects::initProc

proc RichTextObjects::initProc { w args } {
        upvar #0 config$w config
        upvar #0 $w data
        global gui_flags
        global TheoremWidgets_library
        set data(displayed_objects) ""
        upvar #0 $config(selectionVar) selection
        set selection ""
        # puts "config(selectionVar) = $config(selectionVar)"
        
        pack [frame $w.box] -side left -fill y

        if $config(optionButtons) {
            pack [richtextcontrols $w.box.controls \
                -richtextvar [set w](richtext) \
                -showtypesvar [set w](showtypes) \
                -structuredtextvar [set w](structuredtext) \
                -relief sunken \
                -borderwidth 2 \
            ]  -side left -fill y
        }
                                           
        pack [scrollable listbox $w.box.listbox \
                -relief sunken \
                -export false \
                -setgrid 1 \
                -font $gui_flags(font,listboxes)] \
            -side right -fill y
        if {!$config(multiSelect)} {
            tk_listboxSingleSelect [$w.box.listbox listbox]
        }

        bind [$w.box.listbox listbox] <ButtonRelease-1> \
               "$w select;
                $config(selectionCommand);
                $w expandselection"

        # Nb. Creating the RichText frame also sets initial default
        # values for the three variables.

        pack [richtext $w.richtext \
                -richtextvar [set w](richtext) \
                -showtypesvar [set w](showtypes) \
                -structuredtextvar [set w](structuredtext) \
        ] -expand yes -fill both -side right
        
        if $config(expandButtons) {
            pack [button $w.box.controls.expandall -bitmap @$TheoremWidgets_library/src/expandall.xbm -command "$w expandall"]
        }
        if $config(mlbindButtons) {
            pack [button $w.box.controls.mlbindall -bitmap @$TheoremWidgets_library/src/bindall.xbm -command "$w mlbindall"]
        }

        trace variable data(structuredtext) w "after 1 \{$w reformatall\}"
        trace variable data(showtypes) w "after 1 \{$w reformatall\}"
        trace variable data(richtext) w "after 1 \{$w reformatall\}"

        if $gui_flags(debug) { puts "Leaving RichTextObjects"}
        return $w
}

#----------------------------------------------------------------------------
# Widget commands
#
#----------------------------------------------------------------------------

composite_configFlag RichTextObjects selectionVar { w option value } {
        upvar #0 config$w config
        upvar #0 $value selection
        if ![info exists selection] { set selection [$w selection] }
        return private
}
composite_configFlag RichTextObjects showListbox { w arg value } {
        if $value {
            pack $w.box.listbox -side right -fill y
        } else {
            pack forget $w.box.listbox
        }
        return private
}

composite_configFlag RichTextObjects showControls { w arg value } {
        if $value {
            pack $w.box.controls -side left -fill y
            pack $w.box -fill y -side left
        } else {
            pack forget $w.box.controls
            pack forget $w.box
        }
        return private
}


composite_subcommand RichTextObjects listbox { w args } {
        if {[llength $args] > 0} {
            eval $w.box.listbox.b $args
        } else {
            return [$w.box.listbox listbox]
        }
}

composite_subcommand RichTextObjects richtext { w args } {
        if {[llength $args] > 0} {
            eval $w.richtext $args
        } else {
            return $w.richtext
        }
}


composite_subcommand RichTextObjects editpreterm { w args } {
        $w setobjects {}
        eval $w.richtext editpreterm $args
}

composite_subcommand RichTextObjects getpreterm { w args } {
        eval $w.richtext getpreterm $args
}


composite_subcommand RichTextObjects addobjects { w args } {
        upvar #0 $w data
        set listbox [$w.box.listbox listbox]
        foreach obj_name_spec_pair $args {
            set name [lindex $obj_name_spec_pair 0]
            set objspec [lindex $obj_name_spec_pair 1]
            set header [lindex $obj_name_spec_pair 2]
            set size [$w.box.listbox listbox size]
            set inserted 0
            for {set i 0} {$i < $size} {incr i} {
                if {[$listbox get $i] > $name} {
                    $listbox insert $i $name
                    set inserted 1
                    break
                }
            }
            if {!$inserted} {
                $listbox insert end $name
            }
            $listbox yview [expr $i-2]
            set data(objs,$name) $objspec
            if {$header != ""} {
                set data(headers,$name) $header
            }
        }
}


composite_subcommand RichTextObjects setobjects { w args } {
        upvar #0 $w data
        $w.box.listbox listbox delete 0 end
        $w.richtext deleteall
        foreach name [array names data] {
            if [regexp \^.*,displayid\$ $name] {
                unset data($name)
            } 
            if [regexp \^header,.*\$ $name] {
                unset data($name)
            }
            if [regexp \^objs,.*\$ $name] {
                unset data($name)
            }
        }
        set names ""
        foreach obj_name_spec_pair $args {
            set name [lindex $obj_name_spec_pair 0]
            set objspec [lindex $obj_name_spec_pair 1]
            set header [lindex $obj_name_spec_pair 2]
            lappend names $name
                # puts "objspec (A) = $objspec"
            set data(objs,$name) $objspec
            if {$header != ""} {
                set data(headers,$name) $header
            }
        }
        eval [list $w.box.listbox listbox insert end] $names
}



composite_subcommand RichTextObjects deleteobjects { w args } {
        upvar #0 $w data
        global busy
        incr busy
        foreach name $args {
            if [info exists data($name,displayid)] {
                $w.richtext deletethm $data($name,displayid)
                unset data($name,displayid)
            }

            # search through the listbox for the object to delete

            set size [$w.box.listbox listbox size]
            for {set i 0} {$i < $size} {incr i} {
                if {[$w.box.listbox listbox get $i]==$name} {
                    $w.box.listbox listbox delete $i
                    break
                }
            }
        }
        incr busy -1
}






#----------------------------------------------------------------------------
# RichTextObjectss::expand
#
#----------------------------------------------------------------------------


composite_subcommand RichTextObjects expand { w args } {
        upvar #0 $w data
        global feedback
#       global busy
#       incr busy
#       set feedback [list $w "Expanding..."]
        foreach name $args {
            set objspec $data(objs,$name)
            if {![info exists data($name,displayid)]} {
                set size [$w.box.listbox listbox size]
                for {set i 0} {$i < $size} {incr i} {
                    set prev_name [$w.box.listbox listbox get $i]
                    if {$name==$prev_name} { break }
                    if [info exists data($prev_name,displayid)] {
                        set prev_displayid $data($prev_name,displayid)
                    }
                }
                if [info exists data(header,$name)] {
                    set headerargs [list -header $data(header,$name)]
                } else {
                    set headerargs [list -header [list [list "$name\n" thmname]]]
                }
                if {[info exists prev_displayid]} {                                                                          
                    set afterargs [list -after $prev_displayid]
                } else {
                    set afterargs ""
                }
                # puts "name = $name, objspec = $objspec"
                set data($name,displayid) [eval [list $w.richtext insertobject $objspec] $afterargs $headerargs]
            } else {
                $w.richtext yviewobject $data($name,displayid)
            }
        }
#       incr busy -1
}

composite_subcommand RichTextObjects select { w args } {
        global vals
        upvar #0 $w data
        upvar #0 config$w config
        upvar #0 $config(selectionVar) selection
        if {[lindex $args 0]=="all"} {
            $w.box.listbox listbox select from 0
            $w.box.listbox listbox select to end
        } else {
            foreach name $args {
                set size [$w.box.listbox listbox size]
                for {set i 0} {$i < $size} {incr i} {
                    if {[$w.box.listbox listbox get $i]==$name} {
                        $w.box.listbox listbox select from $i
                        break
                    }
                }
            }
        }
        set selection [$w selection]
        if $config(exportSelection) {
            selection own [$w.box.listbox listbox] "catch \{$w.box.listbox listbox select clear\}; set $config(selectionVar) {}"
            selection handle [$w.box.listbox listbox] "RichTextObjects::provide_selection_STRING" STRING
            if {[llength $selection] == 1} {
               set objspec $data(objs,[lindex $selection 0])
               set vals(selection,STRING) [[lindex $objspec 0]::code [lindex $objspec 1]]
            } else {
               set codelist ""
               foreach name $selection {
                  set objspec $data(objs,$name)
                  lappend codelist [[lindex $objspec 0]::code [lindex $objspec 1]]
               }
               set vals(selection,STRING) [ml_list $codelist]
            }
        }
}

#----------------------------------------------------------------------------
# RichTextObjectss::selection
#
# Returns the names/objspecs of the selected objects
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects selection { w } {
        upvar #0 $w data
        set sel [$w.box.listbox listbox curselection]
        set names ""
        foreach index $sel {
            set name [$w.box.listbox listbox get $index]
            lappend names $name
        }
        return $names
}

composite_subcommand RichTextObjects objspec { w name } {
        upvar #0 $w data
        return $data(objs,name)
}

composite_subcommand RichTextObjects expandselection { w } {
#       global busy
#       incr busy
        global feedback
        upvar #0 $w data
        upvar #0 config$w config
#       set feedback [list $w "Expanding object..."]
        set selection [$w selection]
        eval [list $w expand] $selection
#       incr busy -1
}


proc RichTextObjects::provide_selection_STRING { from size } {
        global vals
        return [string range $vals(selection,STRING) $from [expr $from+$size-1]]
}

#----------------------------------------------------------------------------
# $w expandall
#
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects expandall { w } {
        upvar #0 $w data                     
        global busy
        incr busy
        set size [$w.box.listbox listbox size]
        
        for {set i 0} {$i<$size} {incr i} {
            set name [$w.box.listbox listbox get $i]
            if {$name==""} break
            set objspec [set data(objs,$name)]
            if {![info exists data($name,displayid)]} {
                if [info exists data(header,$name)] {
                    set headerargs [list -header $data(header,$name)]
                } else {
                    set headerargs [list -header [list [list "$name\n" thmname]]]
                }
                if {[info exists prev_displayid]} {                                                                          
                    set afterargs [list -after $prev_displayid]
                } else {
                    set afterargs ""
                }
                set displayid [eval [list $w.richtext insertobject $objspec] $afterargs $headerargs]
                set data($name,displayid) $displayid
                $w.richtext yviewobject $displayid
                update idletasks
            }
            set prev_displayid $data($name,displayid) 
        }
        if {$size>0} {
            $w.richtext yviewobject $data([$w.box.listbox listbox get 0],displayid) 
        }
        incr busy -1
}

#----------------------------------------------------------------------------
# $w objects
#
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects objects { w } {
        upvar #0 $w data                     
        set size [$w.box.listbox listbox size]
        set names ""
        for {set i 0} {$i<$size} {incr i} {
            set name [$w.box.listbox listbox get $i]
            lappend names $name
        }
        return $names
}

#----------------------------------------------------------------------------
# $w objspec_for_object
#
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects objspec_for_object { w name } {
        upvar #0 $w data                     
        return $data(objs,$name)
}


#----------------------------------------------------------------------------
# $w reformatall
#
# args are ignored
#----------------------------------------------------------------------------

composite_subcommand RichTextObjects reformatall { w args } {
        upvar #0 $w data
        global busy
        incr busy
        $w.richtext deleteall
        set size [$w.box.listbox listbox size]
        for {set i 0} {$i<$size} {incr i} {
            set name [$w.box.listbox listbox get $i]
            set objspec [set data(objs,$name)]
            if {[info exists data($name,displayid)]} {
                if [info exists data(header,$name)] {
                    set headerargs [list -header $data(header,$name)]
                } else {
                    set headerargs [list -header [list [list "$name\n" thmname]]]
                }
                if {[info exists prev_displayid]} {                                                                          
                    set afterargs [list -after $prev_displayid]
                } else {
                    set afterargs ""
                }
                set data($name,displayid) [eval [list $w.richtext insertobject $objspec] $afterargs $headerargs]
                if ![info exists first] { set first $data($name,displayid) }
                set prev_displayid $data($name,displayid)
                $w.richtext yviewobject $data($name,displayid)
                update idletasks
            }
        }
        if [info exists first] {
            $w.richtext yviewobject $first
        }
        incr busy -1
}

#----------------------------------------------------------------------------
# $w mlbind
#
#----------------------------------------------------------------------------


composite_subcommand RichTextObjects mlbindselection { w } {
        global busy
        incr busy
        set names [$w selection]
        if {[llength $names]==0} { 
            errormessage $w.error "Select a object to bind first"
            return
        }
        foreach name $names {
            $w mlbind $name
        }
        incr busy -1
}

composite_subcommand RichTextObjects mlbindall { w } {
        global feedback
        upvar #0 $w data
        global busy
        incr busy
        set names [$w objects]
        if {[llength $names]==0} { incr busy -1; return }
        set name [lindex $names 0]
        set objspec $data(objs,$name)
        set code [[lindex $objspec 0]::code [lindex $objspec 1]]
        append code_to_run "[ml_val] $name = $code"
        for {set i 1} {$i < [llength $names]} {incr i 50} {
            foreach name [lrange $names $i [expr $i+49]] {
                set objspec $data(objs,$name)
                set code [[lindex $objspec 0]::code [lindex $objspec 1]]
                append code_to_run "\n and $name = $code"
            }
        }
        set feedback [list $w "Binding ML identifiers ..."]
        ML -toplevel 1 -log 1 $code_to_run
        incr busy -1
}

composite_subcommand RichTextObjects mlbind { w name } {
        global feedback
        upvar #0 $w data
        set feedback [list $w "Binding ML identifier $name"]
        set objspec $data(objs,$name)
        set code [[lindex $objspec 0]::code [lindex $objspec 1]]
        ML -toplevel 1 -log 1 "[ml_val] $name = $code"
}



