(%--------------------------------------------------------------------------%)
(%                  Copyright (c) Donald Syme 1992                          %)
(%                  All rights reserved                                     %)
(%                                                                          %)
(% Donald Syme, hereafter referred to as `the Author', retains the copyright%)
(% and all other legal rights to the Software contained in this file,       %)
(% hereafter referred to as `the Software'.                                 %)
(%                                                                          %)
(% The Software is made available free of charge on an `as is' basis. No    %)
(% guarantee, either express or implied, of maintenance, reliability,       %)
(% merchantability or suitability for any purpose is made by the Author.    %)
(%                                                                          %)
(% The user is granted the right to make personal or internal use of the    %)
(% Software provided that both:                                             %)
(% 1. The Software is not used for commercial gain.                         %)
(% 2. The user shall not hold the Author liable for any consequences        %)
(%    arising from use of the Software.                                     %)
(%                                                                          %)
(% The user is granted the right to further distribute the Software         %)
(% provided that both:                                                      %)
(% 1. The Software and this statement of rights are not modified.           %)
(% 2. The Software does not form part or the whole of a system distributed  %)
(%    for commercial gain.                                                  %)
(%                                                                          %)
(% The user is granted the right to modify the Software for personal or     %)
(% internal use provided that all of the following conditions are observed: %)
(% 1. The user does not distribute the modified software.                   %)
(% 2. The modified software is not used for commercial gain.                %)
(% 3. The Author retains all rights to the modified software.               %)
(%                                                                          %)
(% Anyone seeking a licence to use this software for commercial purposes is %)
(% invited to contact the Author.                                           %)
(%--------------------------------------------------------------------------%)




(%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 % FILE          : sml.pp                                                   
 % DESCRIPTION   : Pretty-printer for SML constructs
 %                                                                          
 % AUTHOR        : D.R.Syme
 %
 % load_library {lib=find_library "mlpretty_runtime", theory="-"};
 % use "hol90_mlpretty_runtime/src/prettyp/ppboxes_hide_label.sml";
 % use "hol90_mlpretty_runtime/src/prettyp/ppout.sml";
 % use "/homes/drs1004/projects/tkhol/smlpp/src/sml.pp.support.sml";
 % use "/homes/drs1004/projects/tkhol/smlpp/pp/sml.pp.sml";
 % use "/homes/drs1004/projects/tkhol/smlpp/src/smlpp.sml";
 %
 % structure PPOut = PPOutFun(SMLPP.PP);
 % val pp_exp = PPOut.display_ppbox o SMLPP.print_exp;
 % val pp_exps = pp_exp o parse_exp;
 % val pp_dec = PPOut.display_ppbox o SMLPP.print_dec;
 % val pp_decs = pp_dec o parse_dec;
 % val pp_int = PPOut.display_ppbox o SMLPP.print_int;
 % val pp_sym = PPOut.display_ppbox o SMLPP.print_symbol;
 % val pp_path = PPOut.display_ppbox o SMLPP.print_path;
 % val MarkExp (VarExp [sym],_,_) = parse_string "a";;
 % SMLDestructors.VarExp (VarExp [sym]);;
 % pp_exps "1";
 % pp_exps "f a";
 % pp_exps "f a b";
 % pp_exps "f (a b)";
 % pp_exps "(f a) b";
 % pp_exps "(f a; f b)";
 % pp_exps "(1; (f a; f b))";
 % pp_exps "`abc`";
 % pp_exps "`abc ^(1)`";
 % pp_exps "`abc ^(f x)`";
 % pp_exp (VarExp [sym]);
 % pp_decs "1";
 % pp_decs "val x = 1";
 % pp_decs "fun f (HD a) = 1 | f _ = 2";
 % pp_exp (MarkExp (VarExp [sym],1,1));
 % pp_sym sym;
 % pp_path [sym];
 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%)
 
strings for Terminal =
end strings


prettyprinter SML =

(% Precedence table for SML types and terms %)

(% Values have been chosen to allow user-defined objects to have a %)
(% precedence between the precedences of any built-in objects.     %)

attributes

   "#appl"                              2000; 
   "if"                                 400;  
   "fn"                                 300;  
   "while"                              300;  
   "case"                               300;  
   "handle"                             200;  
   "raise"                              200;  
   ";"                                  100; 
   ":"                                  0;   (% Type information %)

   s where is_infix(s) -> 1000;   (% Infixes %)
end attributes

depth = infinity;

parameters
   context = "";
end parameters


patterns

   BINOP(*op,*arg1,*arg2) = DAppExp(DVarExp(*op),D2TupleExp(*arg1,*arg2));
   UNOP(*op,*arg) = DAppExp(DVarExp(*op),*arg);

(%   Nil() = DVarExp(DSymbol("nil");
   Cons(*hd,*tl) = DAppExp(DVarExp(DSymbol("::")),D2Tuple(*hd,*tl))
   List(**elems) = [Cons(*elems,<>)]Nil();
%)

end patterns

rules for int =
   i -> (int_to_string(i));
end rules

rules for real =
   r -> (real_to_string(r));
end rules

rules for bool =
   b -> if b then "true" else "false";
end rules

rules for symbol =
   DSymbol(s) -> s;
end rules

rules for path =
   DPath(**syms.*sym) -> [<h 0> **[<h 0> *syms:symbol "."] *sym:symbol];
end rules

rules for ruless =
   DRules(**ruless.*rule) ->
            [<hov 1,3,1> **[<h 1> *ruless:rule "|"] *rule:rule];
end rules

rules for tyvar =
   DTyv(*sym) -> *sym:symbol;
end rules


rules for ty =
   DVarTy(*tyvar) -> *tyvar:tyvar;
   DConTy(*path,**tys) -> 
        [<h 1> **[<h 0> *tys:ty] *path:path];
end rules

rules for exp =

   DFragList(*elem.**elems) -> 
        [lpar{"`"} 
        [<hv 0,0,0> "`" *elem:frag **[<h 0> *elems:frag] "`"]
         rpar{"`"}];
   DNil() -> "[]";
   DList(**elems.*elem) -> 
        [<hv 0,0,1> "[" **[<h 0> *elems ","] *elem "]"];

   DAppExp(DAppExp(DVarExp(last(DSymbol(op))),DFragList(**elems)),*arg2) where is_parser(op) -> 
        [<h 0> lpar{op} op [<hv 0,0,0> "`" **[<h 0> *elems:frag] "`"] (*arg2 <= op) rpar{op}];

   [BINOP(last(DSymbol(op)),*args,<1..:op>)]*arg where is_infix(op) ->
      [lpar{op}
       [<hv 1,0,0> **[<hv 1,0,0> (**args <= op) op] (*arg <= op)]
       rpar{op}];

   DIntExp(*i) -> *i:int;
   DRealExp(r) -> r;
   DStringExp(s) -> [<h 0> "\"" s "\""];
   DRecordExp(.) -> "{}";
   DVarExp(*path) -> *path:path;
   DFnExp(*ruless) -> 
        [lpar{"fn"} [<hv 1,2,1> "fn" *ruless:ruless] rpar{"fn"}];
   [DAppExp(<1..>,*arguments)]*function ->
        [lpar{"#appl"}
            [<hov 1,3,1> (*function <= "#appl") (**<->arguments <= "#appl")]
         rpar{"#appl"}];
   DCaseExp(*expr,*ruless) -> 
        [lpar{"case"} [<hov 1,2,1> [<h 1> "case" *expr "of"] *ruless:ruless] rpar{"case"}];
   DLetExp(*dec,*expr) -> 
        [<hov 1,3,1> "let" 
             *dec:dec 
         <1,0,1> "in" <1,3,1> 
             *expr 
         <1,0,1> "end"];
   DSeqExp(**exprs.*expr) -> 
      [lpar{";"}
        [<hv 1,3,0> **[<h 0> (*exprs <= ";") ";"] (*expr <= ";")]
        rpar{";"}];
   DRecordExp(**symexps.*symexp) ->
        [<hov 1,3,0> "{" 
            **[<h 0> *symexps:symexp ","]
            [<h 0> *symexp:symexp]
         <1,0,0> "}"];
   DTupleExp(**exps.*exp) ->
        [lpar{","}
          [<hov 1,0,0> **[<h 0> (*exps:exp <= ",") ","] (*exp:exp <= ",")]
          rpar{","}];
   DSelectorExp(*sym) -> [<h 0> "#" *sym:symbol];
   DConstraintExp(*expr,*constraint) -> 
        [lpar{":"} [<h 0> *expr ":" *constraint:ty] rpar{":"}];
   DHandleExp(*expr,*ruless) -> 
        [lpar{"handle"} 
          [<hov 1,3,1> 
           *expr
           "handle" *ruless:ruless]
         rpar{"handle"}];
   DRaiseExp(*exp) -> 
        [lpar{"raise"} 
          [<h 1> "raise" *exp]
          rpar{"raise"}];
   DIfExp(*test,*thencase,*elsecase) ->
        [lpar{"if"} 
        [<hov 1,0,1> 
           [<h 1> "if" *test]
           [<h 1> "then" *thencase]
           [<h 1> "else" *elsecase]]
          rpar{"if"}];
   DAndalsoExp(*l,*r) ->
        [lpar{"andalso"} 
        [<hv 0,0,1> *l "andalso" *r]
         rpar{"andalso"}];
   DOrelseExp(*l,*r) ->
        [lpar{"orelse"} 
        [<hv 0,0,1> *l "orelse" *r]
         rpar{"orelse"}];
(%   VectorExp -> %)
   DWhileExp(*test,*expr) ->
        [lpar{"while"} 
        [<hov 1,0,1> 
           [<h 1> "while" (*test <= "while")]
           [<h 1> "do" (*expr <= "while")]]
         rpar{"while"}];
end rules

rules for symexp =
    DSymExp(*sym,*exp) -> [<h 0> *sym:symbol " = " *exp:exp];
end rules

rules for frag =
   DQuote(DStringExp(s)) -> s;
   DAntiquote(*exp) -> [<h 0> "^(" *exp:exp ")"];
end rules

rules for rule =
    DRule(*pat,*exp) ->
        [<hov 1,3,1> *pat:pat "=>" *exp:exp];
end rules

rules for pat =
    DWildPat() -> "_";
    DVarPat(*path) -> *path:path;
    DIntPat(*i) -> *i:int;
    DRealPat(r) -> r;
    DStringPat(s) -> s;
    DRecordPat(.,*flexibility) -> "{}";
    DRecordPat(**sympats.*sympat,*flexibility) ->
        [<hv 1,3,0> "{" 
            **[<h 0> *sympats:sympat ","]
            *sympats:sympat
         <1,0,0> "}"];
    DTuplePat(**pats.*pat) ->
        [<hov 1,3,0> "(" 
            **[<h 0> *pats:pat ","]
            *pat:pat
         <1,0,1> ")"];
   DAppPat(*constr,*argument) ->
        [lpar{"#appl"} 
            [<hov 1,3,1> (*constr:path <= "#appl") (*argument <= "#appl")]
         rpar{"#appl"}];
   DConstraintPat(*pattern,*constraint) -> [<h 0> *pattern ":" *constraint:ty];
(%   DLayeredPat(*varPat,*expPat) -> %)
(%   DVectorPat(*pats) -> %)
end rules

rules for sympat =
    DSymPat(*sym,*pat) -> [<h 0> *sym:symbol ":" *pat:pat];
end rules

rules for dec =

   DValDec(*vb.**vbs) -> 
      [<v 0,0> [<h 1> "val" *vb:vb]
             **[<h 1> "and" *vbs:vb]];
   DValrecDec(*rvb.**rvbs) -> 
      [<h 1> "rec" [<v 0,0> [<h 1> "rec val" *rvb:rvb]
                          **[<h 1> "and" *rvbs:rvb]]];
   DFunDec(*fb.**fbs) -> 
      [<v 0,0> [<h 1> "fun" *fb:fb]
             **[<h 1> "and" *fbs:fb]];

   DTypeDec(*tb.**tbs) -> 
      [<v 0,0> [<h 1> "type" *tb:tb]
             **[<h 1> "and" *tbs:tb]];

   DDatatypeDec(*datatyc.**datatycs,.) -> 
      [<v 0,0> [<h 1> "datatype" *datatyc:db]
             **[<h 1> "and" *datatycs:db]];

   DDatatypeDec(*datatyc.**datatycs,*withtyc.**withtycs) -> 
      [<v 0,0> [<h 1> "datatype" *datatyc:db]
             **[<h 1> "and" *datatycs:db]
               [<h 1> "with " *withtyc:tb]
             **[<h 1> "and" *withtycs:tb]];

   DAbstypeDec(*abstyc.**abstycs, ., *body) -> 
      [<v 0,0> [<h 1> "abstype" *abstyc:db]
             **[<h 1> "and" *abstycs:db]
               [<h 1> "with" *body:dec]];

   DAbstypeDec(*abstyc.**abstycs, *withtyc.**withtycs, *body) -> 
      [<v 0,0> [<h 1> "abstype" *abstyc:db]
             **[<h 1> "and" *abstycs:db]
               [<h 1> "withtype" *withtyc:tb]
             **[<h 1> "and" *withtycs:tb]
               [<h 1> "with" *body:dec]];

   DExceptionDec(*eb.**ebs) -> 
      [<v 0,0> [<h 1> "exception" *eb:eb]
             **[<h 1> "and" *ebs:eb]];

(%   DStrDec(*strb.**strbs) -> 
      [<v 0,0> [<h 1> "structure" *strb:strb] 
             **[<h 1> "and" *strbs:strb]];

   DAbsDec(*strb.**strbs) -> 
      [<v 0,0> [<h 1> "abstraction" *strb:strb] 
             **[<h 1> "and" *strbs:strb]];

   DFctDec(*fctb.**fctbs) -> 
      [<v 0,0> [<h 1> "functor" *fctb:fctb] 
             **[<h 1> "and" *fctbs:fctb]];

   DSigDec(*sigb.**sigbs) -> 
      [<v 0,0> [<h 1> "signature" *sigb:sigb] 
             **[<h 1> "and" *sigbs:sigb]];

   DFsigDec(*fsigb.**fsigbs) -> 
      [<v 0,0> [<h 1> "fsignature" *fsigb:fsigb] 
             **[<h 1> "and" *fsigbs:fsigb]];
%)

   DLocalDec(*dec1,*dec2) -> 
      [<hov 1,3,1> "local"
                   *dec1
           <1,0,1> "in"
           <1,3,1> *dec2
           <1,0,1> "end"];

   DSeqDec(**decs.*dec) -> 
      [<v 0,0> **[<h 1> *decs:dec ";"] *dec];

   DOpenDec(**syms) -> 
      [<h 1> "open" **[<h 1> *syms:path]];

(%   DFixDec(*fixity,*ops) -> 
      [<h 1> "" *path:path]; %)
end rules

rules for vb =
   DVb(*pat,*exp) ->
      [<h 1> *pat:pat "=" *exp:exp];
end rules

rules for rvb =
   DRvb(*var,*exp,*resultty) ->
      [<h 1> *var:symbol "=" *exp:exp];
end rules

rules for fb =
   DFb(*val,**clauses.*clause) ->
      [<v 0,0> **[<h 1> *val:symbol *clauses:clause "|"]
                 [<h 1> *val:symbol *clause:clause]];
end rules

rules for clause =
   DClause(**pats,*resultty,*exp) ->
      [<h 1> **[<hov 0,0,1> *pats:pat] "=" *exp:exp];
end rules

rules for tb =
   DTb(*tyc,*def,**tyvs) ->
      [<h 1> "type" **[*tyvs:tyvar] *tyc:symbol "=" *def:ty];
end rules

rules for db =
   DDb(*tyc,**tyvs,*def.**defs) ->
      [<h 1> "datatype" **[*tyvs:tyvar] *tyc:symbol "=" 
            [<hov 0,0,1> *def:def **[<h 1> "|" *defs:def]]];
end rules

rules for def =
   DDbDef(*symbol,DSOME(*ty)) ->
      [<h 1> *symbol:symbol *ty:ty];
   DDbDef(*symbol,DNONE()) ->
      [<h 1> *symbol:symbol];
end rules

rules for eb =
   DEbGen(*exn,DSOME(*etype)) ->
      [<h 1> *exn:symbol *etype:ty];
   DEbGen(*exn,DNONE()) ->
      [<h 1> *exn:symbol];
   DEbDef(*exn,*edef) ->
      [<h 1> *exn:symbol *edef:path];
end rules



end prettyprinter


