(*--------------------------------------------------------------------------*)
(*                  Copyright (c) Donald Syme 1992                          *)
(*                  All rights reserved                                     *)
(*                                                                          *)
(* Donald Syme, hereafter referred to as `the Author', retains the copyright*)
(* and all other legal rights to the Software contained in this file,       *)
(* hereafter referred to as `the Software'.                                 *)
(*                                                                          *)
(* The Software is made available free of charge on an `as is' basis. No    *)
(* guarantee, either express or implied, of maintenance, reliability,       *)
(* merchantability or suitability for any purpose is made by the Author.    *)
(*                                                                          *)
(* The user is granted the right to make personal or internal use of the    *)
(* Software provided that both:                                             *)
(* 1. The Software is not used for commercial gain.                         *)
(* 2. The user shall not hold the Author liable for any consequences        *)
(*    arising from use of the Software.                                     *)
(*                                                                          *)
(* The user is granted the right to further distribute the Software         *)
(* provided that both:                                                      *)
(* 1. The Software and this statement of rights are not modified.           *)
(* 2. The Software does not form part or the whole of a system distributed  *)
(*    for commercial gain.                                                  *)
(*                                                                          *)
(* The user is granted the right to modify the Software for personal or     *)
(* internal use provided that all of the following conditions are observed: *)
(* 1. The user does not distribute the modified software.                   *)
(* 2. The modified software is not used for commercial gain.                *)
(* 3. The Author retains all rights to the modified software.               *)
(*                                                                          *)
(* Anyone seeking a licence to use this software for commercial purposes is *)
(* invited to contact the Author.                                           *)
(*--------------------------------------------------------------------------*)




structure ProofsBranches = struct
   type branch = string
   val string_of_branch = I;
end

structure ProofsLabels = PPLabels
structure ProofsStringTable = PPStringTable

structure ProofsConstructors = struct  end;

structure ProofsDestructors : ProofsDestructors_sig = struct 
   structure ProofsBranches = ProofsBranches
   structure PPLabels = PPLabels
   structure BwdProofs = BwdProofs
   structure PartialBwdProofs = PartialBwdProofs

   open PPLabels
   open BwdProofs
   open PartialBwdProofs

   fun upto from to =
      if (from > to)
      then []
      else (Integer.makestring from)::(upto (from + 1) to); 

   fun SINGLE [x] = x
   fun TAC (tac,label) = tac
   fun BWDTAC (BWDTAC tac,label) = (tac,label_aBranch "L" label)
   fun label_branch label (n,p) = (p,label_aBranch n label)
   fun numberl l = (combine (upto 1 (length l),l))
   fun BWDPROOF (BWDPROOF l,label) = 
       map (label_branch label) (numberl l)
   fun BWDTHENL (BWDTHENL l,label) = 
       map (label_branch label) (numberl l)
   val SINGLE_BWDTHENL = SINGLE o BWDTHENL

   infix |>
   fun a |> b = b a
   fun split_at n l = 
      let val (l,r) = split_after (n-1) l
      in (l,SOME (hd r),tl r) handle _ => (l,NONE,r)
      end
   fun PBWDTAC (PBWDTAC tac,label) = (tac,label_aBranch "L" label)
   fun PBWDPROOF (PBWDPROOF (focus,l),label) = 
      let val (hardl,focus_op,softl) = split_at focus l
          val nhardl = combine (upto 1 (focus - 1),hardl)
          val nsoftl = combine (upto (focus + 1) (length l),softl)
          fun label_hard (n,p) = (p,label |> label_uKind (SOME "HARD")
                                          |> label_aBranch n)
          fun label_soft (n,p) = (p,label |> label_uKind (SOME "SOFT")
                                          |> label_aBranch n)
          val focus_opl = 
              case focus_op of
                 SOME bwdop => 
                   [(bwdop,label |> label_uKind (SOME (case bwdop of 
                                         PartialBwdProofs.PBWDTAC _ => "SOFT" | 
                                         _ => "HARD")) 
                                 |> label_aBranch (Integer.makestring focus)
                    )]
               | NONE => []
      in
       map label_hard nhardl @ focus_opl @ map label_soft nsoftl
      end
   fun PBWDTHENL (PBWDTHENL l,label) = 
       map (label_branch label) (numberl l)
   val SINGLE_PBWDTHENL = SINGLE o PBWDTHENL
end;

structure ProofsExternals = struct end;
                
