	
structure ProofsPP = 
struct

structure Const = ProofsConstructors
and Dest = ProofsDestructors
and Ext = ProofsExternals
and StringTable = ProofsStringTable
and Labels = ProofsLabels;

type parameters = {
   dummy: bool
}

structure PP =
struct

structure LabelPPBoxes = LabelPPBoxesFun (struct val char_size = 1000; end);

open LabelPPBoxes;

fun pp label s =
   let val pieces = StringTable.lookup (label,s) in
   pp_h_box label 0 
       (map (fn (mapped_label,mapped_string,mapped_width) =>
           pp_string_box mapped_label (mapped_string,mapped_width)) pieces)
   end;

end;

structure Local =
struct open PrettySupport;

       fun precedence _ = 0;

       fun attrib s att = let fun attrib _ = (fn _ => "")
                          in StringTable.attrib s att
                             handle StringTable.StringTable => attrib s att
                          end;

       fun is s att =
          let fun is _ = (fn _ => false)
          in StringTable.is s att handle StringTable.StringTable => is s att
          end;

       val box_el = el PP.pp_empty_box;

       fun lower_prec s = PREC (2 * precedence s - 1);

       fun upper_prec s = PREC (2 * precedence s);

       fun lpar label prec s = if prec_test (prec,upper_prec s)
                               then PP.pp label "("
                               else PP.pp_empty_box;

       fun rpar label prec s = if prec_test (prec,upper_prec s)
                               then PP.pp label ")"
                               else PP.pp_empty_box; end;

val initial_precedence = Local.MINPREC;

val error = "";

val elision = " ... ";

val default_h = 0
and default_v = (PP.ABSOLUTE 0,0)
and default_hv = (0,PP.ABSOLUTE 0,0)
and default_hov = (0,PP.ABSOLUTE 0,0);

structure D = Dest;

val initial_depth = ~1;

val initial_params = {dummy = true};

local
   open Const
in

fun pp_tac {outer_prec,depth} {dummy = dummy'} (tr as (_,label)) =
   if depth = 0
   then PP.pp label elision
   else let val tr1 = D.TAC tr
            val tac' = tr1 in PP.pp_h_box label 0 [PP.pp label tac'] end
        handle _ => PP.pp label error
and pp_bwdop {outer_prec,depth} {dummy = dummy'} (tr as (_,label)) =
   if depth = 0
   then PP.pp label elision
   else let val tr1 = D.BWDTAC tr
            val tac' = tr1
        in PP.pp_h_box label 1000
              [PP.pp label "THEN",
               pp_tac {outer_prec = Local.MINPREC,depth = depth - 1}
                  {dummy = dummy'} tac']
        end
        handle _ =>
        let val tr1 = D.SINGLE_BWDTHENL tr
            val case' = tr1
        in PP.pp_h_box label 0
              [pp_bwdproof {outer_prec = Local.MINPREC,depth = depth - 1}
                  {dummy = dummy'} case']
        end handle _ =>
            let val tr1 = D.BWDTHENL tr
                val tr1rev = rev tr1
                val tr11 = rev (tl tr1rev)
                and tr12 = hd tr1rev
                val cases' = tr11
                val case' = tr12
            in PP.pp_v_box label (PP.ABSOLUTE 0,0)
                  ([PP.pp_h_box label 1000 [PP.pp label "THENL ["]] @
                   map (fn el => PP.pp_h_box label 0
                                    [PP.pp label "   ",
                                     Local.box_el
                                        (pp_bwdproof
                                            {outer_prec = Local.MINPREC,
                                             depth = depth - 1}
                                            {dummy = dummy'}) cases' el,
                                     PP.pp label ","])
                      (Local.upto 1 (length cases')) @
                   [PP.pp_h_box label 0
                       [PP.pp label "   ",
                        pp_bwdproof
                           {outer_prec = Local.MINPREC,depth = depth - 1}
                           {dummy = dummy'} case'],PP.pp label "]"])
            end handle _ => PP.pp label error
and pp_bwdproof {outer_prec,depth} {dummy = dummy'} (tr as (_,label)) =
   if depth = 0
   then PP.pp label elision
   else let val tr1 = D.BWDPROOF tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val tr111 = D.BWDTAC tr11
            val hd' = tr111
            val ops' = tr12
        in PP.pp_v_box label (PP.ABSOLUTE 0,0)
              ([pp_tac {outer_prec = Local.MINPREC,depth = depth - 1}
                   {dummy = dummy'} hd'] @
               map (fn el => PP.pp_h_box label 1000
                                [Local.box_el
                                    (pp_bwdop {outer_prec = Local.MINPREC,
                                               depth = depth - 1}
                                        {dummy = dummy'}) ops' el])
                  (Local.upto 1 (length ops')))
        end handle _ => PP.pp label error
and pp_pbwdop {outer_prec,depth} {dummy = dummy'} (tr as (_,label)) =
   if depth = 0
   then PP.pp label elision
   else let val tr1 = D.PBWDTAC tr
            val tac' = tr1
        in PP.pp_h_box label 1000
              [PP.pp label "THEN",
               pp_tac {outer_prec = Local.MINPREC,depth = depth - 1}
                  {dummy = dummy'} tac']
        end
        handle _ =>
        let val tr1 = D.SINGLE_PBWDTHENL tr
            val case' = tr1
        in PP.pp_h_box label 0
              [pp_pbwdproof {outer_prec = Local.MINPREC,depth = depth - 1}
                  {dummy = dummy'} case']
        end handle _ =>
            let val tr1 = D.PBWDTHENL tr
                val tr1rev = rev tr1
                val tr11 = rev (tl tr1rev)
                and tr12 = hd tr1rev
                val cases' = tr11
                val case' = tr12
            in PP.pp_v_box label (PP.ABSOLUTE 0,0)
                  ([PP.pp_h_box label 1000 [PP.pp label "THENL ["]] @
                   map (fn el => PP.pp_h_box label 0
                                    [PP.pp label "   ",
                                     Local.box_el
                                        (pp_pbwdproof
                                            {outer_prec = Local.MINPREC,
                                             depth = depth - 1}
                                            {dummy = dummy'}) cases' el,
                                     PP.pp label ","])
                      (Local.upto 1 (length cases')) @
                   [PP.pp_h_box label 0
                       [PP.pp label "   ",
                        pp_pbwdproof
                           {outer_prec = Local.MINPREC,depth = depth - 1}
                           {dummy = dummy'} case'],PP.pp label "]"])
            end handle _ => PP.pp label error
and pp_pbwdproof {outer_prec,depth} {dummy = dummy'} (tr as (_,label)) =
   if depth = 0
   then PP.pp label elision
   else let val tr1 = D.PBWDPROOF tr
            val tr11 = hd tr1
            and tr12 = tl tr1
            val tr111 = D.PBWDTAC tr11
            val hd' = tr111
            val ops' = tr12
        in PP.pp_v_box label (PP.ABSOLUTE 0,0)
              ([pp_tac {outer_prec = Local.MINPREC,depth = depth - 1}
                   {dummy = dummy'} hd'] @
               map (fn el =>
                       PP.pp_h_box label 1000
                          [Local.box_el
                              (pp_pbwdop {outer_prec = Local.MINPREC,
                                          depth = depth - 1}
                                  {dummy = dummy'}) ops' el])
                  (Local.upto 1 (length ops')))
        end handle _ => PP.pp label error;

end;

val print_tac =
   pp_tac {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_bwdop =
   pp_bwdop {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_bwdproof =
   pp_bwdproof {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_pbwdop =
   pp_pbwdop {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

val print_pbwdproof =
   pp_pbwdproof {outer_prec = initial_precedence,depth = initial_depth}
      initial_params;

end;
