
#----------------------------------------------------------------------------
# ProofsPP::ProcessArgs
#
#       -norichtext     turn rich text output off.  Automatically off
#                       for hol90.
#
#----------------------------------------------------------------------------

proc ProofsPP::ProcessArgs { argc argv } {
        global ProofsPP_flags

   if {[llength [info commands Preferences_Add]]==1} {

    Preferences_Add "Proof Display" \
"Preferences related to the formatting of HOL proofs may be \
specified here.  Interface maps dictate the fonts and colors that \
proofs will be displayed in." [list \
        [list ProofsPP_flags(mapsOnByDefault) interfaceMapping BOOL 1 "Use Interface Maps by Default" "Whether TkHolWorkbench should use interface maps by default for proofs."] \
        \
        [list ProofsPP_flags(interface_maps) interfaceMaps STRING [list ProofsTk] "ProofsPP Interface Maps" "The interface maps to use when displaying Richtext. These are specified below. "] \
    ]


    Preferences_Add "Interface Maps" \
"Install and alter interface maps.  A proper interface to create, modify and save interface maps will be developed in due course." \
      [list \
        [list ProofsPP_flags(interface_map,ProofsTk) ProofsTk INTERFACE_MAP [list \
            [list [list HARD]   {}              Teletype-Medium-R-Normal-Normal|*-*-*-*-Black-*-0-1-0] \
            [list [list SOFT]   {}              Teletype-Medium-R-Normal-Normal|*-*-*-*-DodgerBlue3-*-0-1-0] \
            [list default       {}              Teletype-Medium-R-Normal-Normal|*-*-*-*-Black-*-0-1-0] \
        ] \
        "ProofTk Interface Map" \
"The interface map used for formatting proofs."] \
      ]


   }

        set ProofsPP_flags(goal_line) ""
        set ProofsPP_flags(wrap_terms) 0

        for {set arg 0} {$arg < $argc} {incr arg} {
            if {[lindex $argv $arg]=="-norichtext"} {
                set ProofsPP_flags(richtext) 0
            }
        }
}


proc ProofsPP::InitialisePackage { } {
        global ProofsPP_flags
        global gui_flags
        set ProofsPP_flags(plaintext_loaded) 0
        set ProofsPP_flags(structuredtext_loaded) 0
        set ProofsPP_flags(notify_loaded) 0
        
        global install_dir_tkhol
        if [hol90] {
            if [catch {ML -toplevel 1 " \n \
                Globals.library_path := \n(!Globals.library_path)@\n\[[ml_string $install_dir_tkhol/hol90/mlpretty_runtime/]\]; \n \
                find_library [ml_string mlpretty_runtime]; \n \
                Globals.library_path := \n(!Globals.library_path)@\n\[[ml_string $install_dir_tkhol/hol90/smlpp/]\]; \n \
                find_library [ml_string smlpp]; \n \
                Globals.library_path := \n(!Globals.library_path)@\n\[[ml_string $install_dir_tkhol/hol90/replay/]\]; \n \
                find_library [ml_string replay]; \n \
                find_library [ml_string goaltrees] \n \
            "}] {
                errormessage .error \
"One of the following library description files
        $install_dir_tkhol/hol90/mlpretty_runtime/mlpretty_runtime.hol_lib 
        $install_dir_tkhol/hol90/smlpp/smlpp.hol_lib 
        $install_dir_tkhol/hol90/replay/replay.hol_lib 
could  not  be  found.  Perhaps  one  of the libraries has not
been   made   for   hol90 or is out of date with respect to \
another library.   Consult   your  $gui_flags(title)
installation  guide  and  remake  the  libraries.  If problems
persist, contact $gui_flags(maintainer)"
            }
        }

}
